/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.ContainerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.LRSMapFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.meta.ClassMetaData;

class GetMapValue
extends AbstractVal {
    private static final long serialVersionUID = 1L;
    private final Val _map;
    private final Val _key;
    private final String _alias;
    private ClassMetaData _meta = null;
    private Class _cast = null;

    public GetMapValue(Val map, Val key, String alias) {
        this._map = map;
        this._key = key;
        this._alias = alias;
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._meta;
    }

    @Override
    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        return this._map.getType();
    }

    @Override
    public void setImplicitType(Class type) {
        this._cast = type;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState mapState = this._map.initialize(sel, ctx, 0);
        ExpState keyState = this._key.initialize(sel, ctx, 0);
        return new GetMapValueExpState(sel.and(mapState.joins, keyState.joins), mapState, keyState);
    }

    @Override
    public Object toDataStoreValue(Select sel, ExpContext ctx, ExpState state, Object val) {
        GetMapValueExpState gstate = (GetMapValueExpState)state;
        return this._map.toDataStoreValue(sel, ctx, gstate.mapState, val);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state).append(" AS ").append(this._alias), (Object)this);
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        GetMapValueExpState gstate = (GetMapValueExpState)state;
        this._map.selectColumns(sel, ctx, gstate.mapState, true);
        this._key.selectColumns(sel, ctx, gstate.keyState, true);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this._alias, asc, false);
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert(res.getObject(this, 1012, null), this.getType());
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        GetMapValueExpState gstate = (GetMapValueExpState)state;
        this._map.calculateValue(sel, ctx, gstate.mapState, null, null);
        this._key.calculateValue(sel, ctx, gstate.keyState, null, null);
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        if (!(this._map instanceof PCPath)) {
            throw new UnsupportedOperationException();
        }
        if (!(this._key instanceof Const)) {
            throw new UnsupportedOperationException();
        }
        GetMapValueExpState gstate = (GetMapValueExpState)state;
        PCPath map = (PCPath)this._map;
        Object key = ((Const)this._key).getValue(ctx, gstate.keyState);
        FieldMapping field = map.getFieldMapping(gstate.mapState);
        if (!(field.getStrategy() instanceof LRSMapFieldStrategy)) {
            throw new UnsupportedOperationException();
        }
        LRSMapFieldStrategy strat = (LRSMapFieldStrategy)field.getStrategy();
        ClassMapping[] clss = strat.getIndependentValueMappings(true);
        if (clss != null && clss.length > 1) {
            throw RelationStrategies.unjoinable(field);
        }
        ClassMapping cls = clss == null || clss.length == 0 ? null : clss[0];
        ForeignKey fk = strat.getJoinForeignKey(cls);
        sql2.append("(SELECT ");
        Column[] values = field.getElementMapping().getColumns();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sql2.append(", ");
            }
            sql2.append(values[i].getTable()).append(".").append(values[i]);
        }
        sql2.append(" FROM ").append(values[0].getTable());
        sql2.append(" WHERE ");
        ContainerFieldStrategy.appendUnaliasedJoin(sql2, sel, null, ctx.store.getDBDictionary(), field, fk);
        sql2.append(" AND ");
        key = strat.toKeyDataStoreValue(key, ctx.store);
        Column[] cols = strat.getKeyColumns(cls);
        Object[] vals = cols.length == 1 ? null : (Object[])key;
        for (int i = 0; i < cols.length; ++i) {
            sql2.append(cols[i].getTable()).append(".").append(cols[i]);
            if (vals == null) {
                sql2.append(key == null ? " IS " : " = ").appendValue(key, cols[i]);
                continue;
            }
            sql2.append(vals[i] == null ? " IS " : " = ").appendValue(vals[i], cols[i]);
        }
        sql2.append(")");
    }

    private static class GetMapValueExpState
    extends ExpState {
        public final ExpState mapState;
        public final ExpState keyState;

        public GetMapValueExpState(Joins joins, ExpState mapState, ExpState keyState) {
            super(joins);
            this.mapState = mapState;
            this.keyState = keyState;
        }
    }
}

