/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import java.io.IOException;
import java.util.function.Function;

class Utils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char EMPTY_HEX_SEPARATOR = '\u0000';
    public static final String HEX_DIGITS = "0123456789abcdef";

    private Utils() {
    }

    public static int length(byte ... a) {
        return a == null ? 0 : a.length;
    }

    public static long getUInt(byte ... buf) {
        return Utils.getUInt(buf, 0, Utils.length(buf));
    }

    public static long getUInt(byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        long l = (long)(buf[off] << 24) & 0xFF000000L;
        l |= (long)(buf[off + 1] << 16) & 0xFF0000L;
        l |= (long)(buf[off + 2] << 8) & 0xFF00L;
        return l |= (long)buf[off + 3] & 0xFFL;
    }

    public static void checkTrue(boolean flag, String message, long value) {
        if (!flag) {
            Utils.throwIllegalArgumentException(message, value);
        }
    }

    public static void throwIllegalArgumentException(String format, Object ... args) {
        throw Utils.createFormattedException(IllegalArgumentException::new, format, args);
    }

    public static <T extends Throwable> T createFormattedException(Function<? super String, ? extends T> constructor, String format, Object ... args) {
        String message = String.format(format, args);
        return (T)((Throwable)constructor.apply(message));
    }

    public static int putUInt(long value, byte[] buf) {
        return Utils.putUInt(value, buf, 0, Utils.length(buf));
    }

    public static int putUInt(long value, byte[] buf, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("Not enough data for a UINT: required=4, available=" + len);
        }
        buf[off] = (byte)(value >> 24 & 0xFFL);
        buf[off + 1] = (byte)(value >> 16 & 0xFFL);
        buf[off + 2] = (byte)(value >> 8 & 0xFFL);
        buf[off + 3] = (byte)(value & 0xFFL);
        return 4;
    }

    public static int hashCode(byte[] a, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int result = 1;
        int pos = offset;
        for (int count = 0; count < len; ++count) {
            byte element = a[pos];
            result = 31 * result + element;
            ++pos;
        }
        return result;
    }

    public static int diffOffset(byte[] a1, int startPos1, byte[] a2, int startPos2, int len) {
        int pos1 = startPos1;
        int pos2 = startPos2;
        for (int count = 0; count < len; ++count) {
            byte v1 = a1[pos1];
            byte v2 = a2[pos2];
            if (v1 != v2) {
                return count;
            }
            ++pos1;
            ++pos2;
        }
        return -1;
    }

    public static String toHex(byte[] array, int offset, int len, char sep) {
        if (len <= 0) {
            return "";
        }
        try {
            return Utils.appendHex(new StringBuilder(len * 3), array, offset, len, sep).toString();
        }
        catch (IOException e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }

    public static <A extends Appendable> A appendHex(A sb, byte[] array, int offset, int len, char sep) throws IOException {
        if (len <= 0) {
            return sb;
        }
        int maxOffset = offset + len;
        for (int curOffset = offset; curOffset < maxOffset; ++curOffset) {
            byte b = array[curOffset];
            if (curOffset > offset && sep != '\u0000') {
                sb.append(sep);
            }
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return Utils.length(cs) <= 0;
    }

    @SafeVarargs
    public static <T> int length(T ... a) {
        return a == null ? 0 : a.length;
    }
}

