/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class ConnectionRedirectBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    private final int _ownMethodId;
    public static final int CLASS_ID = 10;
    private final AMQShortString _host;
    private final AMQShortString _knownHosts;

    public ConnectionRedirectBody(ProtocolVersion protocolVersion, AMQShortString host, AMQShortString knownHosts) {
        this._ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 50 : 42;
        this._host = host;
        this._knownHosts = knownHosts;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return this._ownMethodId;
    }

    public final AMQShortString getHost() {
        return this._host;
    }

    public final AMQShortString getKnownHosts() {
        return this._knownHosts;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._host);
        return size += this.getSizeOf(this._knownHosts);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._host);
        this.writeAMQShortString(buffer, this._knownHosts);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionRedirect(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionRedirectBodyImpl: ");
        buf.append("host=");
        buf.append(this.getHost());
        buf.append(", ");
        buf.append("knownHosts=");
        buf.append(this.getKnownHosts());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientMethodProcessor dispatcher) {
        AMQShortString host = AMQShortString.readAMQShortString(buffer);
        AMQShortString knownHosts = AMQShortString.readAMQShortString(buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionRedirect(host, knownHosts);
        }
    }
}

