/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.Timestamp;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Properties;

public class RestoreRequired
implements Loggable {
    private FailureType failureType;
    private Timestamp time;
    private String propVals;

    public RestoreRequired(FailureType failureType, Properties props) throws IOException {
        this.failureType = failureType;
        this.time = new Timestamp(System.currentTimeMillis());
        StringWriter sw = new StringWriter();
        props.store(sw, null);
        this.propVals = sw.toString();
    }

    public RestoreRequired() {
    }

    public FailureType getFailureType() {
        return this.failureType;
    }

    public Properties getProperties() throws IOException {
        Properties p = new Properties();
        StringReader reader = new StringReader(this.propVals);
        p.load(reader);
        return p;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getStringLogSize(this.failureType.name()) + LogUtils.getTimestampLogSize(this.time) + LogUtils.getStringLogSize(this.propVals);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeString(logBuffer, this.failureType.name());
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeString(logBuffer, this.propVals);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        String typeName = LogUtils.readString(itemBuffer, false, entryVersion);
        this.failureType = FailureType.valueOf(FailureType.class, typeName);
        this.time = LogUtils.readTimestamp(itemBuffer, false);
        this.propVals = LogUtils.readString(itemBuffer, false, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<RestoreRequired failureType=\"").append((Object)this.failureType);
        sb.append("\" time=\"").append(this.time);
        sb.append("\" properties=\"").append(this.propVals);
        sb.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof RestoreRequired)) {
            return false;
        }
        RestoreRequired otherEntry = (RestoreRequired)other;
        if (!this.time.equals(otherEntry.time)) {
            return false;
        }
        return this.propVals.equals(otherEntry.propVals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpLog(sb, true);
        return sb.toString();
    }

    public static enum FailureType {
        NETWORK_RESTORE;

    }
}

