/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeleteConstraintException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForeignConstraintException;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.Get;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryIntegrityException;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.UniqueConstraintException;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ExpirationInfo;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class SecondaryDatabase
extends Database {
    private static final Set<DatabaseEntry> EMPTY_SET = Collections.emptySet();
    private final Database primaryDatabase;
    private SecondaryConfig secondaryConfig;
    private volatile boolean isFullyPopulated = true;

    SecondaryDatabase(Environment env, SecondaryConfig secConfig, Database primaryDatabase) {
        super(env);
        Database foreignDb;
        this.primaryDatabase = primaryDatabase;
        if (primaryDatabase == null) {
            if (secConfig.getSecondaryAssociation() == null) {
                throw new IllegalArgumentException("Exactly one must be non-null: PrimaryDatabase or SecondaryAssociation");
            }
            if (secConfig.getAllowPopulate()) {
                throw new IllegalArgumentException("AllowPopulate must be false when a SecondaryAssociation is configured");
            }
        } else {
            if (secConfig.getSecondaryAssociation() != null) {
                throw new IllegalArgumentException("Exactly one must be non-null: PrimaryDatabase or SecondaryAssociation");
            }
            primaryDatabase.checkOpen();
            if (primaryDatabase.configuration.getSortedDuplicates()) {
                throw new IllegalArgumentException("Duplicates not allowed for a primary database: " + primaryDatabase.getDebugName());
            }
            if (env.getNonNullEnvImpl() != primaryDatabase.getEnvironment().getNonNullEnvImpl()) {
                throw new IllegalArgumentException("Primary and secondary databases must be in the same environment");
            }
            if (!primaryDatabase.configuration.getReadOnly() && secConfig.getKeyCreator() == null && secConfig.getMultiKeyCreator() == null) {
                throw new IllegalArgumentException("SecondaryConfig.getKeyCreator()/getMultiKeyCreator() may be null only if the primary database is read-only");
            }
        }
        if (secConfig.getKeyCreator() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("secConfig.getKeyCreator() and getMultiKeyCreator() may not both be non-null");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getForeignMultiKeyNullifier() != null) {
            throw new IllegalArgumentException("secConfig.getForeignKeyNullifier() and getForeignMultiKeyNullifier() may not both be non-null");
        }
        if (secConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY && secConfig.getForeignKeyNullifier() == null && secConfig.getForeignMultiKeyNullifier() == null) {
            throw new IllegalArgumentException("ForeignKeyNullifier or ForeignMultiKeyNullifier must be non-null when ForeignKeyDeleteAction is NULLIFY");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("ForeignKeyNullifier may not be used with SecondaryMultiKeyCreator -- use ForeignMultiKeyNullifier instead");
        }
        if (secConfig.getForeignKeyDatabase() != null && (foreignDb = secConfig.getForeignKeyDatabase()).getDbImpl().getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a foreign key  database: " + foreignDb.getDebugName());
        }
    }

    @Override
    DatabaseImpl initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) {
        DatabaseImpl dbImpl = super.initNew(env, locker, databaseName, dbConfig);
        this.init(locker);
        return dbImpl;
    }

    @Override
    void initExisting(Environment env, Locker locker, DatabaseImpl database, String databaseName, DatabaseConfig dbConfig) {
        Database otherPriDb;
        if (this.primaryDatabase != null && (otherPriDb = database.findPrimaryDatabase()) != null && otherPriDb.getDbImpl() != this.primaryDatabase.getDbImpl()) {
            throw new IllegalArgumentException("Secondary already associated with different primary: " + otherPriDb.getDebugName());
        }
        super.initExisting(env, locker, database, databaseName, dbConfig);
        this.init(locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Locker locker) {
        this.trace(Level.FINEST, "SecondaryDatabase open");
        this.getDbImpl().setKnownSecondary();
        this.secondaryConfig = (SecondaryConfig)this.configuration;
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            foreignDb.foreignKeySecondaries.add(this);
        }
        if (!this.secondaryConfig.getAllowPopulate()) {
            return;
        }
        Cursor secCursor = null;
        Cursor priCursor = null;
        try {
            secCursor = new Cursor((Database)this, locker, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationResult result = secCursor.position(key, data, LockMode.DEFAULT, null, true);
            if (result != null) {
                return;
            }
            priCursor = new Cursor(this.primaryDatabase, locker, null);
            result = priCursor.position(key, data, LockMode.DEFAULT, null, true);
            while (result != null) {
                this.updateSecondary(locker, secCursor, key, null, data, null, result.getExpirationTime(), false, result.getExpirationTime());
                result = priCursor.retrieveNext(key, data, LockMode.DEFAULT, null, GetMode.NEXT);
            }
        }
        finally {
            if (secCursor != null) {
                secCursor.close();
            }
            if (priCursor != null) {
                priCursor.close();
            }
        }
    }

    @Override
    SecondaryAssociation makeSecondaryAssociation() {
        if (this.primaryDatabase != null) {
            this.primaryDatabase.simpleAssocSecondaries.add(this);
            return this.primaryDatabase.secAssoc;
        }
        return this.configuration.getSecondaryAssociation();
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    @Override
    void removeReferringAssociations() {
        Database foreignDb;
        super.removeReferringAssociations();
        if (this.primaryDatabase != null) {
            this.primaryDatabase.simpleAssocSecondaries.remove(this);
        }
        if (this.secondaryConfig != null && (foreignDb = this.secondaryConfig.getForeignKeyDatabase()) != null) {
            foreignDb.foreignKeySecondaries.remove(this);
        }
    }

    public void startIncrementalPopulation() {
        this.isFullyPopulated = false;
    }

    public void endIncrementalPopulation() {
        this.isFullyPopulated = true;
    }

    public boolean isIncrementalPopulationEnabled() {
        return !this.isFullyPopulated;
    }

    public boolean deleteObsoletePrimaryKeys(DatabaseEntry key, DatabaseEntry data, int batchSize) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", false);
            if (batchSize <= 0) {
                throw new IllegalArgumentException("batchSize must be positive");
            }
            DatabaseImpl dbImpl = this.checkOpen();
            this.trace(Level.FINEST, "deleteObsoletePrimaryKeys", null, key, null, null);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, null, dbImpl.isInternalDb(), this.isTransactional(), dbImpl.isReplicated());
            try {
                boolean result;
                try (Cursor cursor = new Cursor((Database)this, locker, null);){
                    result = this.deleteObsoletePrimaryKeysInternal(cursor, locker, key, data, batchSize);
                }
                locker.operationEnd(true);
                return result;
            }
            catch (Throwable e) {
                locker.operationEnd(false);
                throw e;
            }
        }
        catch (Error E) {
            this.envHandle.invalidate(E);
            throw E;
        }
    }

    private boolean deleteObsoletePrimaryKeysInternal(Cursor cursor, Locker locker, DatabaseEntry key, DatabaseEntry data, int batchSize) {
        OperationResult searchResult;
        LockMode scanMode = LockMode.RMW;
        if (key.getData() == null) {
            searchResult = cursor.position(key, data, scanMode, null, true);
        } else {
            searchResult = cursor.search(key, data, scanMode, null, SearchMode.BOTH_RANGE, false);
            if (searchResult == null) {
                searchResult = cursor.search(key, data, scanMode, null, SearchMode.SET_RANGE, false);
            }
        }
        int nProcessed = 0;
        while (searchResult != null) {
            if (nProcessed >= batchSize) {
                return true;
            }
            ++nProcessed;
            if (this.secAssoc.getPrimary(data) == null) {
                cursor.deleteNoNotify(null, this.getDbImpl().getRepContext());
            }
            searchResult = cursor.retrieveNext(key, data, scanMode, null, GetMode.NEXT);
        }
        return false;
    }

    @Override
    public void populateSecondaries(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        throw new UnsupportedOperationException("Not allowed on a secondary");
    }

    @Override
    public void populateSecondaries(Transaction txn, DatabaseEntry key, DatabaseEntry data, long expirationTime, CacheMode cacheMode) {
        throw new UnsupportedOperationException("Not allowed on a secondary");
    }

    public Database getPrimaryDatabase() {
        return this.primaryDatabase;
    }

    @Override
    public List<SecondaryDatabase> getSecondaryDatabases() {
        return Collections.emptyList();
    }

    public SecondaryConfig getSecondaryConfig() {
        return this.getConfig();
    }

    @Override
    public SecondaryConfig getConfig() {
        return (SecondaryConfig)super.getConfig();
    }

    SecondaryConfig getPrivateSecondaryConfig() {
        return this.secondaryConfig;
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig cursorConfig) {
        return this.openCursor(txn, cursorConfig);
    }

    @Override
    public SecondaryCursor openCursor(Transaction txn, CursorConfig cursorConfig) {
        this.checkReadable();
        return (SecondaryCursor)super.openCursor(txn, cursorConfig);
    }

    @Override
    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) {
        return new SecondaryCursor(this, txn, cursorConfig);
    }

    /*
     * Exception decompiling
     */
    @Override
    public OperationResult delete(Transaction txn, DatabaseEntry key, WriteOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OperationStatus delete(Transaction txn, DatabaseEntry key) {
        OperationResult result = this.delete(txn, key, null);
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationResult get(Transaction txn, DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        return this.get(txn, key, null, data, getType, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, Get getType, ReadOptions options) {
        try {
            CursorConfig cursorConfig;
            this.checkEnv();
            this.checkReadable();
            if (options == null) {
                options = Cursor.DEFAULT_READ_OPTIONS;
            }
            LockMode lockMode = options.getLockMode();
            this.trace(Level.FINEST, "SecondaryDatabase.get", String.valueOf((Object)getType), txn, key, null, lockMode);
            this.checkLockModeWithoutTxn(txn, lockMode);
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = READ_COMMITTED_CURSOR_CONFIG;
                lockMode = null;
            } else {
                cursorConfig = DEFAULT_CURSOR_CONFIG;
            }
            OperationResult result = null;
            Locker locker = LockerFactory.getReadableLocker((Database)this, txn, cursorConfig.getReadCommitted());
            try {
                try (SecondaryCursor cursor = new SecondaryCursor(this, locker, cursorConfig);){
                    result = cursor.getInternal(key, pKey, data, getType, options, lockMode);
                }
                locker.operationEnd(result != null);
            }
            catch (Throwable throwable) {
                locker.operationEnd(result != null);
                throw throwable;
            }
            return result;
        }
        catch (Error E) {
            this.envHandle.invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return this.get(txn, key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(txn, key, pKey, data, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(txn, key, pKey, data, Get.SEARCH_BOTH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationResult put(Transaction txn, DatabaseEntry key, DatabaseEntry data, Put putType, WriteOptions options) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public JoinCursor join(Cursor[] cursors, JoinConfig config) {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateSecondary(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData, CacheMode cacheMode, long expirationTime, boolean expirationUpdated, long oldExpirationTime) {
        Set<DatabaseEntry> toUpdate;
        Set<DatabaseEntry> toInsert;
        Set<DatabaseEntry> toDelete;
        Set<DatabaseEntry> newKeys;
        Set<DatabaseEntry> oldKeys;
        boolean localCursor;
        boolean expirationInHours = TTL.isSystemTimeInHours(expirationTime);
        int expiration = TTL.systemTimeToExpiration(expirationTime, expirationInHours);
        SecondaryKeyCreator keyCreator = this.secondaryConfig.getKeyCreator();
        SecondaryMultiKeyCreator multiKeyCreator = this.secondaryConfig.getMultiKeyCreator();
        boolean bl = localCursor = cursor == null;
        if (keyCreator != null) {
            boolean doUpdate;
            assert (multiKeyCreator == null);
            DatabaseEntry oldSecKey = null;
            DatabaseEntry newSecKey = null;
            if (!(oldData == null && newData != null || keyCreator.createSecondaryKey(this, priKey, oldData, oldSecKey = new DatabaseEntry()))) {
                oldSecKey = null;
            }
            if (newData != null && !keyCreator.createSecondaryKey(this, priKey, newData, newSecKey = new DatabaseEntry())) {
                newSecKey = null;
            }
            boolean doDelete = oldSecKey != null && !oldSecKey.equals(newSecKey);
            boolean doInsert = newSecKey != null && !newSecKey.equals(oldSecKey);
            boolean bl2 = doUpdate = expirationUpdated && newSecKey != null && !doInsert;
            if (doDelete || doInsert || doUpdate) {
                if (localCursor) {
                    cursor = new Cursor((Database)this, locker, null);
                }
                try {
                    if (doDelete) {
                        this.deleteKey(cursor, priKey, oldSecKey, cacheMode, oldExpirationTime);
                    }
                    if (doInsert) {
                        this.insertKey(locker, cursor, priKey, newSecKey, cacheMode, expiration, expirationInHours, oldExpirationTime);
                    }
                    if (doUpdate) {
                        this.updateExpiration(cursor, priKey, oldSecKey, cacheMode, expiration, expirationInHours, oldExpirationTime);
                    }
                }
                finally {
                    if (localCursor) {
                        cursor.close();
                    }
                }
            }
            return (doDelete ? 1 : 0) + (doInsert ? 1 : 0) + (doUpdate ? 1 : 0);
        }
        if (multiKeyCreator == null) {
            throw new IllegalArgumentException("SecondaryConfig.getKeyCreator()/getMultiKeyCreator() may be null only if the primary database is read-only");
        }
        if (oldData == null && newData != null) {
            oldKeys = EMPTY_SET;
        } else {
            oldKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, oldData, oldKeys);
        }
        if (newData == null) {
            newKeys = EMPTY_SET;
        } else {
            newKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, newData, newKeys);
        }
        if (oldKeys.isEmpty()) {
            toDelete = EMPTY_SET;
        } else {
            toDelete = new HashSet<DatabaseEntry>(oldKeys);
            toDelete.removeAll(newKeys);
        }
        if (newKeys.isEmpty()) {
            toInsert = EMPTY_SET;
        } else {
            toInsert = new HashSet<DatabaseEntry>(newKeys);
            toInsert.removeAll(oldKeys);
        }
        if (!expirationUpdated || newKeys.isEmpty()) {
            toUpdate = EMPTY_SET;
        } else {
            toUpdate = new HashSet<DatabaseEntry>(newKeys);
            toUpdate.retainAll(oldKeys);
        }
        if (!(toDelete.isEmpty() && toInsert.isEmpty() && toUpdate.isEmpty())) {
            if (localCursor) {
                cursor = new Cursor((Database)this, locker, null);
            }
            try {
                if (!toDelete.isEmpty()) {
                    for (DatabaseEntry secKey : toDelete) {
                        this.deleteKey(cursor, priKey, secKey, cacheMode, oldExpirationTime);
                    }
                }
                if (!toInsert.isEmpty()) {
                    for (DatabaseEntry secKey : toInsert) {
                        this.insertKey(locker, cursor, priKey, secKey, cacheMode, expiration, expirationInHours, oldExpirationTime);
                    }
                }
                if (!toUpdate.isEmpty()) {
                    for (DatabaseEntry secKey : toUpdate) {
                        this.updateExpiration(cursor, priKey, secKey, cacheMode, expiration, expirationInHours, oldExpirationTime);
                    }
                }
            }
            finally {
                if (localCursor) {
                    cursor.close();
                }
            }
        }
        return toDelete.size() + toInsert.size() + toUpdate.size();
    }

    private void deleteKey(Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldSecKey, CacheMode cacheMode, long oldExpirationTime) {
        OperationResult result = cursor.search(oldSecKey, priKey, LockMode.RMW, cacheMode, SearchMode.BOTH, false);
        if (result != null) {
            cursor.deleteInternal(this.getDbImpl().getRepContext(), cacheMode);
            return;
        }
        if (this.isFullyPopulated && !this.getEnv().expiresWithin(oldExpirationTime, this.getEnv().getTtlClockTolerance())) {
            throw new SecondaryIntegrityException(cursor.getCursorImpl().getLocker(), "Secondary is corrupt: the primary record contains a key that is not present in the secondary", this.getDebugName(), oldSecKey, priKey, oldExpirationTime);
        }
    }

    private void insertKey(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry newSecKey, CacheMode cacheMode, int expiration, boolean expirationInHours, long oldExpirationTime) {
        OperationResult result;
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            try (Cursor foreignCursor = new Cursor(foreignDb, locker, null);){
                DatabaseEntry tmpData = new DatabaseEntry();
                OperationResult result2 = foreignCursor.search(newSecKey, tmpData, LockMode.DEFAULT, cacheMode, SearchMode.SET, true);
                if (result2 == null) {
                    throw new ForeignConstraintException(locker, "Secondary " + this.getDebugName() + " foreign key not allowed: it is not" + " present in the foreign database " + foreignDb.getDebugName(), this.getDebugName(), newSecKey, priKey, oldExpirationTime);
                }
            }
        }
        ExpirationInfo expInfo = new ExpirationInfo(expiration, expirationInHours, false);
        if (this.configuration.getSortedDuplicates()) {
            result = cursor.putInternal(newSecKey, priKey, cacheMode, expInfo, PutMode.NO_DUP_DATA);
            if (result == null && this.isFullyPopulated) {
                throw new SecondaryIntegrityException(locker, "Secondary/primary record already present", this.getDebugName(), newSecKey, priKey, oldExpirationTime);
            }
        } else {
            result = cursor.putInternal(newSecKey, priKey, cacheMode, expInfo, PutMode.NO_OVERWRITE);
            if (result == null && this.isFullyPopulated) {
                throw new UniqueConstraintException(locker, "Unique secondary key is already present", this.getDebugName(), newSecKey, priKey, oldExpirationTime);
            }
        }
    }

    private void updateExpiration(Cursor cursor, DatabaseEntry priKey, DatabaseEntry secKey, CacheMode cacheMode, int expiration, boolean expirationInHours, long oldExpirationTime) {
        PutMode putMode;
        ExpirationInfo expInfo = new ExpirationInfo(expiration, expirationInHours, true);
        EnvironmentImpl envImpl = this.getEnv();
        if (this.isFullyPopulated && !envImpl.expiresWithin(oldExpirationTime, envImpl.getTtlClockTolerance())) {
            OperationResult result = cursor.search(secKey, priKey, LockMode.RMW, cacheMode, this.configuration.getSortedDuplicates() ? SearchMode.BOTH : SearchMode.SET, false);
            if (result == null) {
                throw new SecondaryIntegrityException(cursor.getCursorImpl().getLocker(), "Secondary is corrupt: the primary record contains a key that is not present in the secondary", this.getDebugName(), secKey, priKey, oldExpirationTime);
            }
            putMode = PutMode.CURRENT;
        } else {
            putMode = PutMode.OVERWRITE;
        }
        cursor.putInternal(secKey, priKey, cacheMode, expInfo, putMode);
    }

    void onForeignKeyDelete(Locker locker, DatabaseEntry secKey, CacheMode cacheMode) {
        ForeignKeyDeleteAction deleteAction = this.secondaryConfig.getForeignKeyDeleteAction();
        LockMode lockMode = deleteAction == ForeignKeyDeleteAction.ABORT ? LockMode.DEFAULT : LockMode.RMW;
        try (Cursor cursor = new Cursor((Database)this, locker, null);){
            DatabaseEntry priKey = new DatabaseEntry();
            OperationResult secResult = cursor.search(secKey, priKey, lockMode, cacheMode, SearchMode.SET, true);
            while (secResult != null) {
                Database primaryDb;
                if (deleteAction == ForeignKeyDeleteAction.ABORT) {
                    throw new DeleteConstraintException(locker, "Secondary refers to a deleted foreign key", this.getDebugName(), secKey, priKey, secResult.getExpirationTime());
                }
                if (deleteAction == ForeignKeyDeleteAction.CASCADE) {
                    OperationResult priResult;
                    primaryDb = this.getPrimary(priKey);
                    if (primaryDb != null && (priResult = primaryDb.deleteInternal(locker, priKey, cacheMode)) == null && !cursor.cursorImpl.isProbablyExpired()) {
                        throw this.secondaryRefersToMissingPrimaryKey(locker, secKey, priKey, secResult.getExpirationTime());
                    }
                } else if (deleteAction == ForeignKeyDeleteAction.NULLIFY) {
                    primaryDb = this.getPrimary(priKey);
                    if (primaryDb != null) {
                        Cursor priCursor = new Cursor(primaryDb, locker, null);
                        Throwable throwable = null;
                        try {
                            DatabaseEntry data = new DatabaseEntry();
                            OperationResult priResult = priCursor.search(priKey, data, LockMode.RMW, cacheMode, SearchMode.SET, true);
                            if (priResult == null) {
                                if (cursor.cursorImpl.isProbablyExpired()) continue;
                                throw this.secondaryRefersToMissingPrimaryKey(locker, secKey, priKey, secResult.getExpirationTime());
                            }
                            ForeignMultiKeyNullifier multiNullifier = this.secondaryConfig.getForeignMultiKeyNullifier();
                            if (multiNullifier != null) {
                                if (multiNullifier.nullifyForeignKey(this, priKey, data, secKey)) {
                                    priCursor.putCurrent(data);
                                }
                            } else {
                                ForeignKeyNullifier nullifier = this.secondaryConfig.getForeignKeyNullifier();
                                if (nullifier.nullifyForeignKey(this, data)) {
                                    priCursor.putCurrent(data);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (priCursor == null) continue;
                            if (throwable != null) {
                                try {
                                    priCursor.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            priCursor.close();
                            continue;
                        }
                    }
                } else {
                    throw EnvironmentFailureException.unexpectedState();
                }
                secResult = cursor.retrieveNext(secKey, priKey, LockMode.DEFAULT, cacheMode, GetMode.NEXT_DUP);
            }
        }
    }

    boolean updateMayChangeSecondary() {
        return !this.secondaryConfig.getImmutableSecondaryKey() && !this.secondaryConfig.getExtractFromPrimaryKeyOnly();
    }

    static boolean needOldDataForUpdate(Collection<SecondaryDatabase> secondaries) {
        if (secondaries == null) {
            return false;
        }
        for (SecondaryDatabase secDb : secondaries) {
            if (!secDb.updateMayChangeSecondary()) continue;
            return true;
        }
        return false;
    }

    static boolean needOldDataForDelete(Collection<SecondaryDatabase> secondaries) {
        if (secondaries == null) {
            return false;
        }
        for (SecondaryDatabase secDb : secondaries) {
            if (secDb.secondaryConfig.getExtractFromPrimaryKeyOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean hasSecondaryOrForeignKeyAssociations() {
        return false;
    }

    Database getPrimary(DatabaseEntry priKey) {
        Database priDb;
        try {
            priDb = this.secAssoc.getPrimary(priKey);
        }
        catch (RuntimeException e) {
            throw EnvironmentFailureException.unexpectedException("Exception from SecondaryAssociation.getPrimary", (Exception)e);
        }
        if (priDb == null) {
            return null;
        }
        if (priDb.secAssoc != this.secAssoc) {
            throw new IllegalArgumentException("Primary and secondary have different SecondaryAssociation instances. Remember to configure the SecondaryAssociation on the primary database.");
        }
        return priDb;
    }

    private DatabaseImpl checkReadable() {
        DatabaseImpl dbImpl = this.checkOpen();
        if (!this.isFullyPopulated) {
            throw new IllegalStateException("Incremental population is currently enabled.");
        }
        return dbImpl;
    }

    static UnsupportedOperationException notAllowedException() {
        return new UnsupportedOperationException("Operation not allowed on a secondary");
    }

    void trace(Level level, String methodName) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            sb.append(" name=").append(this.getDebugName());
            sb.append(" primary=").append(this.primaryDatabase.getDebugName());
            LoggerUtils.logMsg(this.logger, this.getEnv(), level, sb.toString());
        }
    }
}

