/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import java.util.regex.Pattern;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.svl.MultipartVar;
import org.apache.juneau.svl.VarResolverSession;

public class SwitchVar
extends MultipartVar {
    public static final String NAME = "SW";

    public SwitchVar() {
        super(NAME);
    }

    @Override
    public String resolve(VarResolverSession session, String[] args) {
        AssertionUtils.assertArg((args.length >= 2 ? 1 : 0) != 0, (String)"Invalid number of arguments passed to $SW var.  Must have 2 or more arguments.", (Object[])new Object[0]);
        String stringArg = args[0];
        for (int i = 1; i < args.length; ++i) {
            String pattern = args[i];
            String[] parts = StringUtils.splita((String)pattern, (char)':', (int)2);
            AssertionUtils.assertArg((parts.length >= 2 ? 1 : 0) != 0, (String)"Invalid arguments passed to $SW var.  Each case statement must contains 'pattern:value'.", (Object[])new Object[0]);
            Pattern p = Pattern.compile(parts[0].replace("*", ".*").replace("?", "."));
            if (!p.matcher(stringArg).matches()) continue;
            return parts[1];
        }
        return "";
    }
}

