/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.svl.VarResolverSession;

public class ResponseAnnotation {
    public static final Response DEFAULT = ResponseAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return ResponseAnnotation.create().on(on);
    }

    public static Builder create(String ... on) {
        return ResponseAnnotation.create().on(on);
    }

    public static boolean empty(Response a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTM {
        private String[] description = new String[0];
        private Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        private Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;
        private Header[] headers = new Header[0];
        private Schema schema = SchemaAnnotation.DEFAULT;
        private String[] examples = new String[0];

        protected Builder() {
            super(Response.class);
        }

        public Response build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder examples(String ... value) {
            this.examples = value;
            return this;
        }

        public Builder headers(Header ... value) {
            this.headers = value;
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder schema(Schema value) {
            this.schema = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Response {
        private final String[] description;
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;
        private final Header[] headers;
        private final Schema schema;
        private final String[] examples;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.examples = (String[])CollectionUtils.copyOf((java.lang.Object[])b.examples);
            this.headers = (Header[])CollectionUtils.copyOf((java.lang.Object[])b.headers);
            this.parser = b.parser;
            this.schema = b.schema;
            this.serializer = b.serializer;
        }

        @Override
        public String[] examples() {
            return this.examples;
        }

        @Override
        public Header[] headers() {
            return this.headers;
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Response[] value();
    }

    public static class Applier
    extends AnnotationApplier<Response, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Response.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Response> ai, BeanContext.Builder b) {
            Response a = (Response)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }
}

