/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordQualityRequirementValidationResult;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsResponseType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordValidationDetailsResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String PASSWORD_VALIDATION_DETAILS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.41";
    private static final byte TYPE_MISSING_CURRENT_PASSWORD = -125;
    private static final byte TYPE_MUST_CHANGE_PW = -124;
    private static final byte TYPE_SECONDS_UNTIL_EXPIRATION = -123;
    private static final long serialVersionUID = -2205640814914704074L;
    private final boolean missingCurrentPassword;
    private final boolean mustChangePassword;
    @Nullable
    private final Integer secondsUntilExpiration;
    @NotNull
    private final List<PasswordQualityRequirementValidationResult> validationResults;
    @NotNull
    private final PasswordValidationDetailsResponseType responseType;

    PasswordValidationDetailsResponseControl() {
        this.responseType = null;
        this.validationResults = null;
        this.missingCurrentPassword = true;
        this.mustChangePassword = true;
        this.secondsUntilExpiration = null;
    }

    public PasswordValidationDetailsResponseControl(@NotNull PasswordValidationDetailsResponseType responseType, @Nullable Collection<PasswordQualityRequirementValidationResult> validationResults, boolean missingCurrentPassword, boolean mustChangePassword, @Nullable Integer secondsUntilExpiration) {
        super(PASSWORD_VALIDATION_DETAILS_RESPONSE_OID, false, PasswordValidationDetailsResponseControl.encodeValue(responseType, validationResults, missingCurrentPassword, mustChangePassword, secondsUntilExpiration));
        this.responseType = responseType;
        this.missingCurrentPassword = missingCurrentPassword;
        this.mustChangePassword = mustChangePassword;
        this.secondsUntilExpiration = secondsUntilExpiration;
        this.validationResults = validationResults == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordQualityRequirementValidationResult>(validationResults));
    }

    public PasswordValidationDetailsResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.responseType = PasswordValidationDetailsResponseType.forBERType(elements[0].getType());
            if (this.responseType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_INVALID_RESPONSE_TYPE.get(StaticUtils.toHex(elements[0].getType())));
            }
            if (this.responseType == PasswordValidationDetailsResponseType.VALIDATION_DETAILS) {
                ASN1Element[] resultElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
                ArrayList<PasswordQualityRequirementValidationResult> resultList = new ArrayList<PasswordQualityRequirementValidationResult>(resultElements.length);
                for (ASN1Element e : resultElements) {
                    resultList.add(PasswordQualityRequirementValidationResult.decode(e));
                }
                this.validationResults = Collections.unmodifiableList(resultList);
            } else {
                this.validationResults = Collections.emptyList();
            }
            boolean missingCurrent = false;
            boolean mustChange = false;
            Integer secondsRemaining = null;
            block9: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -125: {
                        missingCurrent = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    case -124: {
                        mustChange = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    case -123: {
                        secondsRemaining = ASN1Integer.decodeAsInteger(elements[i]).intValue();
                        continue block9;
                    }
                }
            }
            this.missingCurrentPassword = missingCurrent;
            this.mustChangePassword = mustChange;
            this.secondsUntilExpiration = secondsRemaining;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull PasswordValidationDetailsResponseType responseType, @Nullable Collection<PasswordQualityRequirementValidationResult> validationResults, boolean missingCurrentPassword, boolean mustChangePassword, @Nullable Integer secondsUntilExpiration) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        switch (responseType) {
            case VALIDATION_DETAILS: {
                if (validationResults == null) {
                    elements.add(new ASN1Sequence(responseType.getBERType()));
                    break;
                }
                ArrayList<ASN1Element> resultElements = new ArrayList<ASN1Element>(validationResults.size());
                for (PasswordQualityRequirementValidationResult r : validationResults) {
                    resultElements.add(r.encode());
                }
                elements.add(new ASN1Sequence(responseType.getBERType(), resultElements));
                break;
            }
            case NO_PASSWORD_PROVIDED: 
            case MULTIPLE_PASSWORDS_PROVIDED: 
            case NO_VALIDATION_ATTEMPTED: {
                elements.add(new ASN1Null(responseType.getBERType()));
            }
        }
        if (missingCurrentPassword) {
            elements.add(new ASN1Boolean(-125, missingCurrentPassword));
        }
        if (mustChangePassword) {
            elements.add(new ASN1Boolean(-124, mustChangePassword));
        }
        if (secondsUntilExpiration != null) {
            elements.add(new ASN1Integer(-123, secondsUntilExpiration));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public PasswordValidationDetailsResponseType getResponseType() {
        return this.responseType;
    }

    @NotNull
    public List<PasswordQualityRequirementValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public boolean missingCurrentPassword() {
        return this.missingCurrentPassword;
    }

    public boolean mustChangePassword() {
        return this.mustChangePassword;
    }

    @Nullable
    public Integer getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Override
    @NotNull
    public PasswordValidationDetailsResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new PasswordValidationDetailsResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static PasswordValidationDetailsResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(PASSWORD_VALIDATION_DETAILS_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PasswordValidationDetailsResponseControl) {
            return (PasswordValidationDetailsResponseControl)c;
        }
        return new PasswordValidationDetailsResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public static PasswordValidationDetailsResponseControl get(@NotNull LDAPException exception) throws LDAPException {
        return PasswordValidationDetailsResponseControl.get(exception.toLDAPResult());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PW_VALIDATION_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordValidationDetailsResponseControl(responseType='");
        buffer.append(this.responseType.name());
        buffer.append('\'');
        if (this.responseType == PasswordValidationDetailsResponseType.VALIDATION_DETAILS) {
            buffer.append(", validationDetails={");
            Iterator<PasswordQualityRequirementValidationResult> iterator = this.validationResults.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(", missingCurrentPassword=");
        buffer.append(this.missingCurrentPassword);
        buffer.append(", mustChangePassword=");
        buffer.append(this.mustChangePassword);
        if (this.secondsUntilExpiration != null) {
            buffer.append(", secondsUntilExpiration=");
            buffer.append(this.secondsUntilExpiration);
        }
        buffer.append("})");
    }
}

