/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema.mnode.impl;

import java.util.ArrayList;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.container.ConfigMNodeContainer;
import org.apache.iotdb.confignode.persistence.schema.mnode.info.ConfigTableInfo;

public class ConfigTableNode
implements IConfigMNode {
    private IConfigMNode parent;
    private transient String fullPath;
    private final ConfigTableInfo tableNodeInfo;

    public ConfigTableNode(IConfigMNode parent, String name) {
        this.parent = parent;
        this.tableNodeInfo = new ConfigTableInfo(name);
    }

    public TsTable getTable() {
        return this.tableNodeInfo.getTable();
    }

    public void setTable(TsTable table) {
        this.tableNodeInfo.setTable(table);
    }

    public TableNodeStatus getStatus() {
        return this.tableNodeInfo.getStatus();
    }

    public void setStatus(TableNodeStatus status) {
        this.tableNodeInfo.setStatus(status);
    }

    public Set<String> getPreDeletedColumns() {
        return this.tableNodeInfo.getPreDeletedColumns();
    }

    public void addPreDeletedColumn(String column) {
        this.tableNodeInfo.addPreDeletedColumn(column);
    }

    public void removePreDeletedColumn(String column) {
        this.tableNodeInfo.removePreDeletedColumn(column);
    }

    public String getName() {
        return this.tableNodeInfo.getName();
    }

    public void setName(String name) {
        this.tableNodeInfo.setName(name);
    }

    public IConfigMNode getParent() {
        return this.parent;
    }

    public void setParent(IConfigMNode parent) {
        this.parent = parent;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
        }
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        IConfigMNode curr = this;
        while (curr.getParent() != null) {
            curr = (IConfigMNode)curr.getParent();
            builder.insert(0, '.').insert(0, curr.getName());
        }
        return builder.toString();
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        IConfigMNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = (IConfigMNode)temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    public MNodeType getMNodeType() {
        return MNodeType.SG_INTERNAL;
    }

    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitBasicMNode((IMNode)this, context);
    }

    public int estimateSize() {
        return 76 + this.tableNodeInfo.estimateSize();
    }

    public IConfigMNode getAsMNode() {
        return this;
    }

    public boolean hasChild(String name) {
        return false;
    }

    public IConfigMNode getChild(String name) {
        return null;
    }

    public IConfigMNode addChild(String name, IConfigMNode child) {
        return null;
    }

    public IConfigMNode addChild(IConfigMNode child) {
        return null;
    }

    public IConfigMNode deleteChild(String name) {
        return null;
    }

    public IMNodeContainer<IConfigMNode> getChildren() {
        return ConfigMNodeContainer.emptyMNodeContainer();
    }

    public void setChildren(IMNodeContainer<IConfigMNode> children) {
    }

    public boolean isAboveDatabase() {
        return false;
    }

    public boolean isDatabase() {
        return false;
    }

    public IDatabaseMNode<IConfigMNode> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public void setSchemaTemplateId(int id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSchemaTemplateId() {
        return -1;
    }

    @Override
    public void preUnsetSchemaTemplate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollbackUnsetSchemaTemplate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSchemaTemplatePreUnset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsetSchemaTemplate() {
        throw new UnsupportedOperationException();
    }
}

