/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class ArithmeticBinaryTransformer
extends BinaryTransformer {
    protected ArithmeticBinaryTransformer(LayerReader leftReader, LayerReader rightReader) {
        super(leftReader, rightReader);
    }

    @Override
    protected void checkType() {
        if (this.leftReaderDataType == TSDataType.BOOLEAN || this.rightReaderDataType == TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.name());
        }
        if (this.leftReaderDataType == TSDataType.TEXT || this.rightReaderDataType == TSDataType.TEXT) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.name());
        }
    }

    @Override
    protected void transformAndCache(Column leftValues, int leftIndex, Column rightValues, int rightIndex, ColumnBuilder builder) throws QueryProcessException {
        double leftValue = TypeUtils.castValueToDouble(leftValues, this.leftReaderDataType, leftIndex);
        double rightValue = TypeUtils.castValueToDouble(rightValues, this.rightReaderDataType, rightIndex);
        builder.writeDouble(this.evaluate(leftValue, rightValue));
    }

    protected abstract double evaluate(double var1, double var3);

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.DOUBLE};
    }
}

