/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.wal;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.wal.ClusterNode;
import org.apache.ignite.internal.management.wal.WalDeleteCommandArg;
import org.apache.ignite.internal.management.wal.WalTask;
import org.apache.ignite.internal.management.wal.WalTaskResult;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class WalPrintCommand
implements ComputeCommand<WalDeleteCommandArg, WalTaskResult> {
    @Override
    public String description() {
        return "Print absolute paths of unused archived wal segments on each node";
    }

    @Override
    public Class<WalPrintCommandArg> argClass() {
        return WalPrintCommandArg.class;
    }

    @Override
    public Class<WalTask> taskClass() {
        return WalTask.class;
    }

    @Override
    public void printResult(WalDeleteCommandArg arg, WalTaskResult taskRes, Consumer<String> printer) {
        ClusterNode node;
        printer.accept("Unused wal segments per node:");
        printer.accept("");
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> failRes = taskRes.exceptions();
        Map<String, ClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            printer.accept("Node=" + node.getConsistentId());
            printer.accept("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            for (String fileName : entry.getValue()) {
                printer.accept("  " + fileName);
            }
            printer.accept("");
        }
        for (Map.Entry<String, Object> entry : failRes.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            printer.accept("Node=" + node.getConsistentId());
            printer.accept("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            printer.accept("  failed with error: " + ((Exception)entry.getValue()).getMessage());
            printer.accept("");
        }
    }

    public static class WalPrintCommandArg
    extends WalDeleteCommandArg {
        private static final long serialVersionUID = 0L;
    }
}

