/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;

public class FileUtils {
    public static void cleanDirectory(String path) throws IOException {
        LinkedList<Path> paths = new LinkedList<Path>();
        FileUtils.appendOrRemove(paths, Files.newDirectoryStream(Paths.get(path, new String[0])));
        while (!paths.isEmpty()) {
            if (Files.newDirectoryStream(paths.getLast()).iterator().hasNext()) {
                FileUtils.appendOrRemove(paths, Files.newDirectoryStream(paths.getLast()));
                continue;
            }
            Files.delete(paths.removeLast());
        }
    }

    private static void appendOrRemove(LinkedList<Path> paths, DirectoryStream<Path> ds) throws IOException {
        for (Path p : ds) {
            if (Files.isDirectory(p, new LinkOption[0])) {
                paths.add(p);
                continue;
            }
            Files.delete(p);
        }
    }
}

