/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.compute.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoopTask
implements ComputeTask<Object, Object> {
    private int jobs;

    public NoopTask(int jobs) {
        assert (jobs > 0);
        this.jobs = jobs;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        return ComputeJobResultPolicy.WAIT;
    }

    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        HashMap<NoopJob, ClusterNode> map = new HashMap<NoopJob, ClusterNode>((int)((double)(subgrid.size() * this.jobs) / 0.75));
        for (ClusterNode gridNode : subgrid) {
            for (int i = 0; i < this.jobs; ++i) {
                map.put(new NoopJob(), gridNode);
            }
        }
        return map;
    }

    @Nullable
    public Object reduce(List<ComputeJobResult> results) {
        return null;
    }

    public static class NoopJob
    implements ComputeJob,
    Externalizable {
        @Nullable
        public Object execute() {
            return null;
        }

        public void cancel() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

