/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioServerBuffer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;

public class GridBufferedParser
implements GridNioParser {
    private static final int BUF_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private final boolean directBuf;
    private final ByteOrder order;

    public GridBufferedParser(boolean directBuf, ByteOrder order) {
        this.directBuf = directBuf;
        this.order = order;
    }

    public byte[] decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        GridNioServerBuffer nioBuf = (GridNioServerBuffer)ses.meta(BUF_META_KEY);
        if (nioBuf == null) {
            nioBuf = new GridNioServerBuffer();
            GridNioServerBuffer old = ses.addMeta(BUF_META_KEY, nioBuf);
            assert (old == null);
        }
        return nioBuf.read(buf);
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg) throws IOException, IgniteCheckedException {
        byte[] msg0 = (byte[])msg;
        ByteBuffer res = this.directBuf ? ByteBuffer.allocateDirect(msg0.length + 4) : ByteBuffer.allocate(msg0.length + 4);
        res.putInt(msg0.length);
        res.put(msg0);
        res.flip();
        return res;
    }

    public String toString() {
        return GridBufferedParser.class.getSimpleName();
    }
}

