/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageInsertRecord
extends PageDeltaRecord {
    private byte[] payload;

    public DataPageInsertRecord(int grpId, long pageId, byte[] payload) {
        super(grpId, pageId);
        this.payload = payload;
    }

    public byte[] payload() {
        return this.payload;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        assert (this.payload != null);
        AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
        io.addRow(pageAddr, this.payload, pageMem.realPageSize(this.groupId()));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_INSERT_RECORD;
    }

    @Override
    public String toString() {
        return S.toString(DataPageInsertRecord.class, this, "super", (Object)super.toString());
    }
}

