/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.StringTerm;

public final class HeaderTerm
extends StringTerm {
    private static final long serialVersionUID = 8342514650333389122L;
    private final String headerName;

    public HeaderTerm(String header, String pattern) {
        super(pattern);
        this.headerName = header;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public boolean match(Message message) {
        try {
            String[] values = message.getHeader(this.headerName);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (!this.match(value)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HeaderTerm)) {
            return false;
        }
        return this.headerName.equalsIgnoreCase(((HeaderTerm)other).headerName) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.headerName.toLowerCase().hashCode() + super.hashCode();
    }
}

