/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.microprofile.client.sse.SseEventBuilder;
import org.apache.cxf.microprofile.client.sse.SseSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class SsePublisher
implements Publisher<InboundSseEvent> {
    final Executor executor;
    final BufferedReader br;
    final Providers providers;
    final List<SseSubscription> subscriptions = new CopyOnWriteArrayList<SseSubscription>();
    final AtomicBoolean isStarted = new AtomicBoolean(false);

    SsePublisher(InputStream is, Executor executor, Providers providers) {
        this.br = new BufferedReader(new InputStreamReader(is));
        this.executor = executor;
        this.providers = providers;
    }

    public void subscribe(Subscriber<? super InboundSseEvent> subscriber) {
        SseSubscription subscription = new SseSubscription(this, subscriber);
        this.subscriptions.add(subscription);
        subscription.fireSubscribe();
        this.start();
    }

    private void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.executor.execute(() -> {
                try (BufferedReader br2 = this.br;){
                    SseEventBuilder builder = new SseEventBuilder(this.providers);
                    String line = this.br.readLine();
                    while (line != null && !this.subscriptions.isEmpty()) {
                        if (line.startsWith("data:")) {
                            builder.data(this.removeSpace(line.substring(5)));
                        } else if (line.startsWith("id:")) {
                            builder.id(this.removeSpace(line.substring(3)));
                        } else if (line.startsWith("event:")) {
                            builder.name(this.removeSpace(line.substring(6)));
                        } else if (line.startsWith(":")) {
                            builder.comment(this.removeSpace(line.substring(1)));
                        } else if ("".equals(line)) {
                            InboundSseEvent event = builder.build();
                            for (SseSubscription subscription : this.subscriptions) {
                                subscription.fireEvent(event);
                            }
                            builder = new SseEventBuilder(this.providers);
                        }
                        line = this.br.readLine();
                    }
                    for (SseSubscription subscription : this.subscriptions) {
                        subscription.complete();
                    }
                }
                catch (IOException ex) {
                    for (SseSubscription subscription : this.subscriptions) {
                        subscription.fireError(ex);
                    }
                }
            });
        }
    }

    void removeSubscription(SseSubscription subscription) {
        this.subscriptions.remove(subscription);
    }

    private String removeSpace(String s) {
        if (s != null && s.startsWith(" ")) {
            return s.substring(1);
        }
        return s;
    }
}

