/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.database;

import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.eventing.DeliveryType;
import org.apache.cxf.ws.eventing.FilterType;
import org.apache.cxf.ws.eventing.shared.faults.FilteringRequestedUnavailable;
import org.apache.cxf.ws.eventing.shared.utils.FilteringUtil;

public class SubscriptionTicket {
    private EndpointReferenceType endTo;
    private DeliveryType delivery;
    private XMLGregorianCalendar expires;
    private FilterType filter;
    private UUID uuid;
    private boolean wrappedDelivery;
    private boolean nonExpiring;

    public XMLGregorianCalendar getExpires() {
        return this.expires;
    }

    public EndpointReferenceType getEndTo() {
        return this.endTo;
    }

    public void setEndTo(EndpointReferenceType endTo) {
        this.endTo = endTo;
    }

    public DeliveryType getDelivery() {
        return this.delivery;
    }

    public void setDelivery(DeliveryType delivery) {
        this.delivery = delivery;
    }

    public FilterType getFilter() {
        return this.filter;
    }

    public void setFilter(FilterType filter) {
        if (!FilteringUtil.isFilteringDialectSupported(filter.getDialect())) {
            throw new FilteringRequestedUnavailable();
        }
        this.filter = filter;
    }

    public boolean isExpired() {
        if (this.nonExpiring) {
            return false;
        }
        return this.expires.toGregorianCalendar().before(new GregorianCalendar());
    }

    public void setExpires(XMLGregorianCalendar expires) {
        this.expires = expires;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getTargetURL() {
        JAXBElement el = (JAXBElement)this.getDelivery().getContent().get(0);
        return ((EndpointReferenceType)el.getValue()).getAddress().getValue().trim();
    }

    public String getEndToURL() {
        try {
            return this.getEndTo().getAddress().getValue();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getFilterString() {
        try {
            return (String)this.getFilter().getContent().get(0);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isWrappedDelivery() {
        return this.wrappedDelivery;
    }

    public void setWrappedDelivery(boolean wrappedDelivery) {
        this.wrappedDelivery = wrappedDelivery;
    }

    public ReferenceParametersType getNotificationReferenceParams() {
        JAXBElement el = (JAXBElement)this.getDelivery().getContent().get(0);
        return ((EndpointReferenceType)el.getValue()).getReferenceParameters();
    }

    public boolean isNonExpiring() {
        return this.nonExpiring;
    }

    public void setNonExpiring(boolean nonExpiring) {
        this.nonExpiring = nonExpiring;
    }
}

