/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.xml.AbstractMessageWriter;
import org.apache.cxf.aegis.xml.MessageWriter;

public class AttributeWriter
extends AbstractMessageWriter {
    private XMLStreamWriter writer;
    private String namespace;
    private String name;
    private String prefix;

    public AttributeWriter(XMLStreamWriter writer, String name, String namespace) {
        this.writer = writer;
        this.name = name;
        if (namespace == null) {
            namespace = "";
        }
        this.namespace = namespace;
        try {
            this.prefix = namespace.length() > 0 ? ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace) ? NamespaceHelper.getUniquePrefix(writer, namespace, "xsi", true) : NamespaceHelper.getUniquePrefix(writer, namespace, null, true)) : "";
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Couldn't write to stream.");
        }
    }

    @Override
    public void writeValue(Object value) {
        try {
            this.writer.writeAttribute(this.prefix, this.namespace, this.name, value.toString());
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error writing document.", (Throwable)e);
        }
    }

    @Override
    public MessageWriter getAttributeWriter(String nm) {
        throw new IllegalStateException();
    }

    @Override
    public MessageWriter getAttributeWriter(String nm, String ns) {
        throw new IllegalStateException();
    }

    @Override
    public MessageWriter getAttributeWriter(QName qname) {
        throw new IllegalStateException();
    }

    @Override
    public MessageWriter getElementWriter(String nm) {
        throw new IllegalStateException();
    }

    @Override
    public MessageWriter getElementWriter(String nm, String ns) {
        throw new IllegalStateException();
    }

    @Override
    public MessageWriter getElementWriter(QName qname) {
        throw new IllegalStateException();
    }

    @Override
    public String getPrefixForNamespace(String ns) {
        throw new IllegalStateException();
    }

    @Override
    public String getPrefixForNamespace(String ns, String hint) {
        throw new IllegalStateException();
    }

    @Override
    public void close() {
    }
}

