/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.state.jcache;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheSPStateManager
implements SPStateManager {
    public static final String REQUEST_CACHE_KEY = "cxf.samlp.request.state.cache";
    public static final String RESPONSE_CACHE_KEY = "cxf.samlp.response.state.cache";
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-jcache.xml";
    private static final Logger LOG = LoggerFactory.getLogger(JCacheSPStateManager.class);
    private final Cache<String, RequestState> requestCache;
    private final Cache<String, ResponseState> responseCache;
    private final CacheManager cacheManager;

    public JCacheSPStateManager() throws URISyntaxException {
        this(DEFAULT_CONFIG_URL, null);
    }

    public JCacheSPStateManager(Bus bus) throws URISyntaxException {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public JCacheSPStateManager(String configFileURL) throws URISyntaxException {
        this(configFileURL, null);
    }

    public JCacheSPStateManager(String configFile, Bus bus) throws URISyntaxException {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, JCacheSPStateManager.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CachingProvider cachingProvider = Caching.getCachingProvider();
        this.cacheManager = cachingProvider.getCacheManager(this.getConfigFileURL(configFileURL).toURI(), this.getClass().getClassLoader());
        this.requestCache = JCacheSPStateManager.getOrCreate(this.cacheManager, REQUEST_CACHE_KEY, String.class, RequestState.class);
        this.responseCache = JCacheSPStateManager.getOrCreate(this.cacheManager, RESPONSE_CACHE_KEY, String.class, ResponseState.class);
    }

    private static <K, V> Cache<K, V> getOrCreate(CacheManager cacheManager, String name, Class<K> kclass, Class<V> vclass) {
        Cache cache = cacheManager.getCache(name, kclass, vclass);
        if (cache != null) {
            return cache;
        }
        MutableConfiguration cacheConfiguration = new MutableConfiguration();
        cacheConfiguration.setTypes(kclass, vclass);
        return cacheManager.createCache(name, (Configuration)cacheConfiguration);
    }

    private URL getConfigFileURL(URL suppliedConfigFileURL) {
        if (suppliedConfigFileURL == null) {
            try {
                URL configFileURL = Loader.getResource((String)DEFAULT_CONFIG_URL);
                if (configFileURL == null) {
                    configFileURL = new URL(DEFAULT_CONFIG_URL);
                }
                return configFileURL;
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
        return suppliedConfigFileURL;
    }

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        return (ResponseState)this.responseCache.get((Object)securityContextKey);
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        ResponseState responseState = this.getResponseState(securityContextKey);
        if (responseState != null) {
            this.responseCache.remove((Object)securityContextKey);
        }
        return responseState;
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        if (securityContextKey == null || "".equals(securityContextKey)) {
            return;
        }
        this.responseCache.put((Object)securityContextKey, (Object)state);
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        if (relayState == null || "".equals(relayState)) {
            return;
        }
        this.requestCache.put((Object)relayState, (Object)state);
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        RequestState state = (RequestState)this.requestCache.get((Object)relayState);
        if (state != null) {
            this.requestCache.remove((Object)relayState);
        }
        return state;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(REQUEST_CACHE_KEY);
            this.cacheManager.destroyCache(RESPONSE_CACHE_KEY);
            this.cacheManager.close();
        }
    }
}

