/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.jcache;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;
import org.apache.wss4j.common.cache.EHCacheReplayCache;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.apache.wss4j.common.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheTokenReplayCache
implements TokenReplayCache<String> {
    public static final String CACHE_KEY = "cxf.samlp.replay.cache";
    private static final Logger LOG = LoggerFactory.getLogger(EHCacheReplayCache.class);
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-jcache.xml";
    private final Cache<String, EHCacheValue> cache;
    private final CacheManager cacheManager;

    public JCacheTokenReplayCache() throws URISyntaxException {
        this(DEFAULT_CONFIG_URL, null);
    }

    public JCacheTokenReplayCache(Bus bus) throws URISyntaxException {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public JCacheTokenReplayCache(String configFile) throws URISyntaxException {
        this(configFile, null);
    }

    public JCacheTokenReplayCache(String configFile, Bus bus) throws URISyntaxException {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, JCacheTokenReplayCache.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CachingProvider cachingProvider = Caching.getCachingProvider();
        this.cacheManager = cachingProvider.getCacheManager(this.getConfigFileURL(configFileURL).toURI(), this.getClass().getClassLoader());
        this.cache = JCacheTokenReplayCache.getOrCreate(this.cacheManager, CACHE_KEY, String.class, EHCacheValue.class);
    }

    private static <K, V> Cache<K, V> getOrCreate(CacheManager cacheManager, String name, Class<K> kclass, Class<V> vclass) {
        Cache cache = cacheManager.getCache(name, kclass, vclass);
        if (cache != null) {
            return cache;
        }
        MutableConfiguration cacheConfiguration = new MutableConfiguration();
        cacheConfiguration.setTypes(kclass, vclass);
        return cacheManager.createCache(name, (Configuration)cacheConfiguration);
    }

    private URL getConfigFileURL(URL suppliedConfigFileURL) {
        if (suppliedConfigFileURL == null) {
            try {
                URL configFileURL = Loader.getResource((String)DEFAULT_CONFIG_URL);
                if (configFileURL == null) {
                    configFileURL = new URL(DEFAULT_CONFIG_URL);
                }
                return configFileURL;
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
        return suppliedConfigFileURL;
    }

    @Override
    public void putId(String identifier) {
        this.putId(identifier, (Instant)null);
    }

    @Override
    public void putId(String identifier, Instant expiry) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        this.cache.put((Object)identifier, (Object)new EHCacheValue(identifier, expiry));
    }

    @Override
    public boolean contains(String identifier) {
        if (this.cache == null) {
            return false;
        }
        EHCacheValue element = (EHCacheValue)this.cache.get((Object)identifier);
        return element != null;
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(CACHE_KEY);
            this.cacheManager.close();
        }
    }
}

