/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class SequenceMonitor {
    private static final long DEFAULT_MONITOR_INTERVAL = 60000L;
    private static final Logger LOG = LogUtils.getL7dLogger(SequenceMonitor.class);
    private long monitorInterval = 60000L;
    private long firstCheck;
    private final Deque<Long> receiveTimes = new ConcurrentLinkedDeque<Long>();

    public void acknowledgeMessage() {
        long now = System.currentTimeMillis();
        if (0L == this.firstCheck) {
            this.firstCheck = now + this.monitorInterval;
        }
        this.receiveTimes.add(now);
    }

    public int getMPM() {
        long now = System.currentTimeMillis();
        int mpm = 0;
        if (this.firstCheck > 0L && now >= this.firstCheck) {
            long threshold = now - this.monitorInterval;
            while (!this.receiveTimes.isEmpty() && this.receiveTimes.getFirst() <= threshold) {
                this.receiveTimes.removeFirst();
            }
            mpm = this.receiveTimes.size();
        }
        return mpm;
    }

    public long getLastArrivalTime() {
        return !this.receiveTimes.isEmpty() ? this.receiveTimes.getLast() : 0L;
    }

    protected void setMonitorInterval(long i) {
        if (this.receiveTimes.isEmpty()) {
            this.firstCheck = 0L;
            this.monitorInterval = i;
        } else {
            LOG.warning("Cannot change monitor interval at this point.");
        }
    }
}

