/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;

public class RMProperties {
    private SourceSequence sourceSequence;
    private long messageNumber;
    private SequenceType sequence;
    private Collection<SequenceAcknowledgement> acks;
    private Collection<AckRequestedType> acksRequested;
    private CloseSequenceType closeSequence;
    private String namespaceURI;
    private boolean lastMessage;
    private long createdTime = System.currentTimeMillis();

    public Collection<SequenceAcknowledgement> getAcks() {
        return this.acks;
    }

    public Collection<AckRequestedType> getAcksRequested() {
        return this.acksRequested;
    }

    public CloseSequenceType getCloseSequence() {
        return this.closeSequence;
    }

    public SequenceType getSequence() {
        return this.sequence;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public SourceSequence getSourceSequence() {
        return this.sourceSequence;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public void setAcks(Collection<SequenceAcknowledgement> a) {
        this.acks = new CopyOnWriteArrayList<SequenceAcknowledgement>(a);
    }

    public void setAcksRequested(Collection<AckRequestedType> ar) {
        this.acksRequested = new CopyOnWriteArrayList<AckRequestedType>(ar);
    }

    public void setCloseSequence(CloseSequenceType cs) {
        this.closeSequence = cs;
    }

    public void setSequence(SequenceType s) {
        this.sequence = s;
    }

    public void setSequence(SourceSequence seq) {
        this.sourceSequence = seq;
        this.messageNumber = seq.getCurrentMessageNr();
        SequenceType s = new SequenceType();
        s.setIdentifier(seq.getIdentifier());
        s.setMessageNumber(this.messageNumber);
        this.setSequence(s);
        this.lastMessage = seq.isLastMessage();
    }

    public void addAck(DestinationSequence seq) {
        if (null == this.acks) {
            this.acks = new CopyOnWriteArrayList<SequenceAcknowledgement>();
        }
        SequenceAcknowledgement ack = seq.getAcknowledgment();
        this.acks.add(ack);
        seq.acknowledgmentSent();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void exposeAs(String uri) {
        this.namespaceURI = uri;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }
}

