/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.util.Collections;
import java.util.List;
import org.dita.index.IndexEntry;
import org.dita.index.IndexEntryImpl;
import org.w3c.dom.Node;

public class IndexStringProcessor {
    private IndexStringProcessor() {
    }

    public static List<IndexEntry> processIndexString(String indexMarkerString, List<Node> contents) {
        IndexEntry indexEntry = IndexStringProcessor.createIndexEntry(indexMarkerString, contents, null, false);
        String referenceIDBuf = indexEntry.getValue() + ":";
        indexEntry.addRefID(referenceIDBuf);
        return Collections.singletonList(indexEntry);
    }

    public static String normalizeTextValue(String string) {
        if (null != string && string.length() > 0) {
            return string.replaceAll("[\\s\\n]+", " ").trim();
        }
        return string;
    }

    private static IndexEntry createIndexEntry(String value, List<Node> contents, String sortString, boolean isParentNoPage) {
        IndexEntryImpl indexEntry = new IndexEntryImpl(value, sortString, value, contents);
        indexEntry.setSuppressesThePageNumber(isParentNoPage);
        indexEntry.setRestoresPageNumber(false);
        indexEntry.setStartRange(false);
        indexEntry.setEndsRange(false);
        indexEntry.setSortString(sortString);
        return indexEntry;
    }
}

