-- lua program to test dynamic library support with DJGPP.

require "libtest2"
print(string.format('Test of require \"libtest2.so\"\nThe library registers the function names containt in the \"my_lib\" table\nallowing to use \"compute_trig_function\" to access \"compute_cos\" and \"compute_sin\".'))
print("Computes the sin and cos values 0, 30, 60 and 90 degrees." )
pi_half = 1.5707963267948966192313216916398
step = pi_half / 3
for x = 0, pi_half, step do
  local sin_value = my_lib.compute_trig_function(x, "sin")
  local cos_value = my_lib.compute_trig_function(x, "cos")
  local arg = x * 90 / pi_half
  print(string.format('sin(%f) = %f  cos(%f) = %f', arg, sin_value, arg, cos_value))
end
