#include <sys/version.h>
#undef USE_DJGPP_STRL_FCTNS  /*  Use libsupp strlcat and strlcpy.  */
#define TEST_LIBSUPP  1
#if TEST_LIBSUPP
# if (__DJGPP__  == 2) && (__DJGPP_MINOR__ < 4)
#  include <libsupp.h>
# else
#  include "../include/libsupp.h"
# endif
#else
# include <stdio.h>
#endif
#include <float.h>
#include <limits.h>
#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
# include <stdint.h>
#endif
#include <stddef.h>
#include <string.h>
#include <stdlib.h>
#include <libc/ieee.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include "../include/libc/unconst.h"


void flags_test(FILE *out)
{
  fprintf(out, "Testing all flags.\n"
               "==================\n");
#if TEST_LIBSUPP
  fprintf(out, "Flag: \"'\"\n"
               "      The integer portion of the result of a decimal conversion (%%i, %%d, %%u, %%f,\n"
               "      %%F, %%g, or %%G) shall be formatted with thousands' grouping characters.\n"
               "      For other conversions the behavior is undefined. The non-monetary grouping\n"
               "      character is used.\n"
               "arg: %d   format string: \"%%'d\"   <%'d>\n"
               "arg: %d   format string: \"%%'i\"   <%'i>\n"
               "arg: %d   format string: \"%%'u\"   <%'u>\n"
               "arg: %.1f format string: \"%%'f\"   <%'f>\n"
               "arg: %.1f format string: \"%%'F\"   <%'F>\n"
               "arg: %.1f format string: \"%%'g\"   <%'g>\n"
               "arg: %.1f format string: \"%%'G\"   <%'G>\n\n",
               1, 1,
               1, 1,
               1, 1,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0);
#endif



  fprintf(out, "Flag: \"-\"\n"
               "      The result of the conversion shall be left-justified within the field. The\n"
               "      conversion is right-justified if this flag is not specified.\n"
               "arg: %d   format string: \"%%-5d\"   <%-5d>\n"
               "arg: %d   format string: \"%%5d\"    <%5d>\n"
               "arg: %d   format string: \"%%-5i\"   <%-5i>\n"
               "arg: %d   format string: \"%%5i\"    <%5i>\n"
               "arg: %d   format string: \"%%-5o\"   <%-5o>\n"
               "arg: %d   format string: \"%% 5o\"   <%5o>\n"
               "arg: %d   format string: \"%%-5u\"   <%-5u>\n"
               "arg: %d   format string: \"%%5u\"    <%5u>\n"
               "arg: %d  format string: \"%%-5x\"   <%-5x>\n"
               "arg: %d  format string: \"%%5X\"    <%5X>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%-10a\"  <%-10a>\n"
               "arg: %.1f format string: \"%%10A\"   <%10A>\n"
#endif
               "arg: %.1f format string: \"%%-15e\"  <%-15e>\n"
               "arg: %.1f format string: \"%%15E\"   <%15E>\n"
               "arg: %.1f format string: \"%%-10f\"  <%-10f>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%10F\"   <%10F>\n"
#else
               "arg: %.1f format string: \"%%10f\"   <%10f>\n"
#endif
               "arg: %.1f format string: \"%%-10g\"  <%-10g>\n"
               "arg: %.1f format string: \"%%10G\"   <%10G>\n\n",
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               10, 10,
               15, 15,
#if TEST_LIBSUPP
               1.0, 1.0,
               1.0, 1.0,
#endif
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0);



  fprintf(out, "Flag: \"+\"\n"
               "      The result of a signed conversion shall always begin with a sign ('+' or\n"
               "      '-'). The conversion shall begin with a sign only when a negative value\n"
               "      is converted if this flag is not specified.\n"
               "arg: %d   format string: \"%%+d\"   <%+d>\n"
               "arg: %d   format string: \"%%i\"    <%i>\n"
               "arg: %d   format string: \"%%+o\"   <%+o>    WARNING: Sign flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%+u\"   <%+u>    WARNING: Sign flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d  format string: \"%%+x\"   <%+x>    WARNING: Sign flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d  format string: \"%%+X\"   <%+X>    WARNING: Sign flag used with unsigned magnitude. Flag ignored.\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%+a\"   <%+a>\n"
               "arg: %.1f format string: \"%%A\"    <%A>\n"
#endif
               "arg: %.1f format string: \"%%+e\"   <%+e>\n"
               "arg: %.1f format string: \"%%E\"    <%E>\n"
               "arg: %.1f format string: \"%%+f\"   <%+f>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%F\"    <%F>\n"
#else
               "arg: %.1f format string: \"%%f\"    <%f>\n"
#endif
               "arg: %.1f format string: \"%%+g\"   <%+g>\n"
               "arg: %.1f format string: \"%%G\"    <%G>\n\n",
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               10, 10,
               15, 15,
#if TEST_LIBSUPP
               1.0, 1.0,
               1.0, 1.0,
#endif
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0);



  fprintf(out, "Flag: \"<space>\"\n"
               "      If the first character of a signed conversion is not a sign or if a signed\n"
               "      conversion results in no characters, a <space> shall be prefixed to the\n"
               "      result. This means that if the <space> and '+' flags both appear, the\n"
               "      <space> flag shall be ignored.\n"
               "arg: %d   format string: \"%% i\"   <% i>\n"
               "arg: %d   format string: \"%%+ i\"  <%+ i>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
               "arg: %d   format string: \"%% d\"   <% d>\n"
               "arg: %d   format string: \"%% +d\"  <% +d>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
               "arg: %d   format string: \"%% o\"   <% o>    WARNING: Space flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%+ o\"  <%+ o>    WARNING: Sign and space flags used with unsigned magnitude. Flags ignored.\n"
               "arg: %d   format string: \"%% u\"   <% u>    WARNING: Space flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%+ u\"  <%+ u>    WARNING: Sign and space flags used with unsigned magnitude. Flags ignored.\n"
               "arg: %d  format string: \"%% x\"   <% x>    WARNING: Space flag used with unsigned magnitude. Flag ignored.\n"
               "arg: %d  format string: \"%%+ X\"  <%+ X>    WARNING: Sign and space flags used with unsigned magnitude. Flags ignored.\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%% a\"   <% a>\n"
               "arg: %.1f format string: \"%%+ A\"  <%+ A>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
#endif
               "arg: %.1f format string: \"%% e\"   <% e>\n"
               "arg: %.1f format string: \"%% +E\"  <% +E>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
               "arg: %.1f format string: \"%% f\"   <% f>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%+ F\"  <%+ F>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
#else
               "arg: %.1f format string: \"%% +f\"  <% +f>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n"
#endif
               "arg: %.1f format string: \"%% g\"   <% g>\n"
               "arg: %.1f format string: \"%% +G\"  <% +G>   WARNING: Sign and space flags used simultaneously. Space flag ignored.\n\n",
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               10, 10,
               15, 15,
#if TEST_LIBSUPP
               1.0, 1.0,
               1.0, 1.0,
#endif
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0);



  fprintf(out, "Flag: \"#\"\n"
               "      Specifies that the value is to be converted to an alternative form. For o\n"
               "      conversion, it increases the precision (if necessary) to force the first\n"
               "      digit of the result to be zero. For x or X conversion specifiers, a non-\n"
               "      zero result shall have 0x (or 0X) prefixed to it. For a, A, e, E, f, F, g,\n"
               "      and G conversion specifiers, the result shall always contain a radix\n"
               "      character, even if no digits follow the radix character. Without this\n"
               "      flag, a radix character appears in the result of these conversions only if\n"
               "      a digit follows it. For g and G conversion specifiers, trailing zeros\n"
               "      shall not be removed from the result as they normally are. For other\n"
               "      conversion specifiers, the behavior is undefined.\n"
               "arg: %d   format string: \"%%#d\"   <%#d>   WARNING: # flag used with decimal magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%#i\"   <%#i>   WARNING: # flag used with decimal magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%#u\"   <%#u>   WARNING: # flag used with decimal magnitude. Flag ignored.\n"
               "arg: %d   format string: \"%%#o\"   <%#o>\n"
               "arg: %d   format string: \"%%#o\"   <%#o>\n"
               "arg: %d   format string: \"%%#x\"   <%#x>\n"
               "arg: %d   format string: \"%%#X\"   <%#X>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%a\"    <%a>\n"
               "arg: %.1f format string: \"%%#A\"   <%#A>\n"
#endif
               "arg: %.1f format string: \"%%1.e\"  <%1.e>\n"
               "arg: %.1f format string: \"%%#1.E\" <%#1.E>\n"
               "arg: %.1f format string: \"%%1.f\"  <%1.f>\n"
#if TEST_LIBSUPP
               "arg: %.1f format string: \"%%#1.F\" <%#1.F>\n"
#else
               "arg: %.1f format string: \"%%#1.f\" <%#1.f>\n"
#endif
               "arg: %.1f format string: \"%%g\"    <%g>\n"
               "arg: %.1f format string: \"%%#G\"   <%#G>\n\n",
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               0, 0,
               1, 1,
               0, 0,
#if TEST_LIBSUPP
               1.0, 1.0,
               0.0, 0.0,
#endif
               1.0, 1.0,
               0.0, 0.0,
               1.0, 1.0,
               0.0, 0.0,
               1.0, 1.0,
               0.0, 0.0);



  fprintf(out, "Flag: \"0\"\n"
               "      For d, i, o, u, x, X, a, A, e, E, f, F, g, and G conversion specifiers,\n"
               "      leading zeros (following any indication of sign or base) are used to pad\n"
               "      to the field width; no space padding is performed. If the '0' and '-'\n"
               "      flags both appear, the '0' flag is ignored. For d, i, o, u, x, and X\n"
               "      conversion specifiers, if a precision is specified, the '0' flag is\n"
               "      ignored. If the '0' and ''' flags both appear, the grouping characters are\n"
               "      inserted before zero padding. For other conversions, the behavior is\n"
               "      undefined.\n"
               "arg: %d    format string: \"%%05d\"    <%05d>\n"
               "arg: %d    format string: \"%%-05d\"   <%-05d>            WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d    format string: \"%%05.d\"   <%05.d>\n"
               "arg: %d    format string: \"%%05i\"    <%05i>\n"
               "arg: %d    format string: \"%%-05i\"   <%-05i>            WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d    format string: \"%%05.i\"   <%05.i>\n"
               "arg: %d    format string: \"%%05o\"    <%05o>\n"
               "arg: %d    format string: \"%%-05o\"   <%-05o>            WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d    format string: \"%%05.o\"   <%05.o>\n"
               "arg: %d    format string: \"%%05u\"    <%05u>\n"
               "arg: %d    format string: \"%%-05u\"   <%-05u>            WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d    format string: \"%%05.u\"   <%05.u>\n"
               "arg: %d   format string: \"%%05x\"    <%05x>\n"
               "arg: %d   format string: \"%%-05x\"   <%-05x>             WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d   format string: \"%%05.x\"   <%05.x>\n"
               "arg: %d   format string: \"%%05X\"    <%05X>\n"
               "arg: %d   format string: \"%%-05X\"   <%-05X>             WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %d   format string: \"%%05.X\"   <%05.X>\n"
#if TEST_LIBSUPP
               "arg: %.1f  format string: \"%%0-10a\"  <%0-10a>        WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %.1f  format string: \"%%0+10A\"  <%0+10A>\n"
               "arg: %.1f  format string: \"%%010A\"   <%010A>\n"
#endif
               "arg: %.1f  format string: \"%%0-15e\"  <%0-15e>   WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %.1f  format string: \"%%0+15E\"  <%0+15E>\n"
               "arg: %.1f  format string: \"%%015E\"   <%015E>\n"
               "arg: %.1f  format string: \"%%0-10f\"  <%0-10f>        WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
#if TEST_LIBSUPP
               "arg: %.1f  format string: \"%%0+10F\"  <%0+10F>\n"
               "arg: %.1f  format string: \"%%010F\"   <%010F>\n"
#else
               "arg: %.1f  format string: \"%%0+10f\"  <%0+10f>\n"
               "arg: %.1f  format string: \"%%010f\"   <%010f>\n"
#endif
               "arg: %.1f  format string: \"%%0-10g\"  <%0-10g>        WARNING: - and 0 flags used simultaneously. 0 flag ignored.\n"
               "arg: %.1f  format string: \"%%0+10G\"  <%0+10G>\n"
               "arg: %.1f  format string: \"%%010G\"   <%010G>\n\n",
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               1, 1,
               10, 10,
               10, 10,
               10, 10,
               15, 15,
               15, 15,
               15, 15,
#if TEST_LIBSUPP
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
#endif
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0,
               1.0, 1.0);
}


void  length_modifiers_test(FILE *out)
{
  char cv, *pcv;
  short int siv, *psiv;
  long int liv, *pliv;
  long long int lliv, *plliv;
  intmax_t jiv, *pjiv;
  size_t ziv, *pziv;
  ptrdiff_t piv, *ppiv;
  pcv = &cv;
  psiv = &siv;
  pliv = &liv;
  plliv = &lliv;
  pjiv = &jiv;
  pziv = &ziv;
  ppiv = &piv;


  fprintf(out, "\n\nTesting all length modifiers.\n"
               "=============================\n");
  fprintf(out, "Length modifier: \"hh\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a signed char or unsigned char argument\n"
               "                 (the argument will have been promoted according to the integer\n"
               "                 promotions, but its value shall be converted to signed char or\n"
               "                 unsigned char before printing); or that a following n conversion\n"
               "                 specifier applies to a pointer to a signed char argument.\n"
               "arg: CHAR_MAX    format string: \"%%hhd\"   <%hhd>\n"
               "arg: CHAR_MIN    format string: \"%%hhi\"   <%hhi>\n"
               "arg: UCHAR_MAX   format string: \"%%hho\"   <%hho>\n"
               "arg: UCHAR_MAX   format string: \"%%hhu\"   <%hhu>\n"
               "arg: CHAR_MIN    format string: \"%%hhx\"   <%hhx>\n"
               "arg: CHAR_MAX    format string: \"%%hhX\"   <%hhX>\n"
               "arg: -           format string: \"%%hhn\"   (pointer to cv)%hhn\n",
               CHAR_MAX,
               CHAR_MIN,
               UCHAR_MAX,
               UCHAR_MAX ,
               CHAR_MIN,
               CHAR_MAX,
               pcv);
  fprintf(out, "cv=%i\n\n", *pcv);



  fprintf(out, "Length modifier: \"h\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a short or unsigned short argument (the\n"
               "                 argument will have been promoted according to the integer\n"
               "                 promotions, but its value shall be converted to short or\n"
               "                 unsigned short before printing); or that a following n\n"
               "                 conversion specifier applies to a pointer to a short argument.\n"
               "arg: SHRT_MAX    format string: \"%%hd\"   <%hd>\n"
               "arg: SHRT_MIN    format string: \"%%hi\"   <%hi>\n"
               "arg: USHRT_MAX   format string: \"%%ho\"   <%ho>\n"
               "arg: USHRT_MAX   format string: \"%%hu\"   <%hu>\n"
               "arg: SHRT_MIN    format string: \"%%hx\"   <%hx>\n"
               "arg: SHRT_MAX    format string: \"%%hX\"   <%hX>\n"
               "arg: -           format string: \"%%hn\"   (pointer to siv)%hn\n",
               SHRT_MAX,
               SHRT_MIN,
               USHRT_MAX,
               USHRT_MAX,
               SHRT_MIN,
               SHRT_MAX,
               psiv);
  fprintf(out, "siv=%i\n\n", *psiv);



  fprintf(out, "Length modifier: \"l\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a long or unsigned long argument; that a\n"
               "                 following n conversion specifier applies to a pointer to a long\n"
               "                 argument; that a following c conversion specifier applies to a\n"
               "                 wint_t argument; that a following s conversion specifier\n"
               "                 applies to a pointer to a wchar_t argument; or has no effect on\n"
               "                 a following a, A, e, E, f, F, g, or G conversion specifier.\n"
               "arg: LONG_MAX    format string: \"%%ld\"   <%ld>\n"
               "arg: LONG_MIN    format string: \"%%li\"   <%li>\n"
               "arg: ULONG_MAX   format string: \"%%lo\"   <%lo>\n"
               "arg: ULONG_MAX   format string: \"%%lu\"   <%lu>\n"
               "arg: LONG_MIN    format string: \"%%lx\"   <%lx>\n"
               "arg: LONG_MAX    format string: \"%%lX\"   <%lX>\n"
               "arg: -           format string: \"%%ln\"   (pointer to liv)%ln\n"
#if TEST_LIBSUPP
               "arg: %.1f         format string: \"%%la\"   <%la>\n"
               "arg: %.1f         format string: \"%%A\"    <%A>\n"
#endif
               "arg: %.1f         format string: \"%%le\"   <%le>\n"
               "arg: %.1f         format string: \"%%E\"    <%E>\n"
               "arg: %.1f         format string: \"%%lf\"   <%lf>\n"
#if TEST_LIBSUPP
               "arg: %.1f         format string: \"%%F\"    <%F>\n"
#else
               "arg: %.1f         format string: \"%%f\"    <%f>\n"
#endif
               "arg: %.1f         format string: \"%%lg\"   <%lg>\n"
               "arg: %.1f         format string: \"%%G\"    <%G>\n",
               LONG_MAX,
               LONG_MIN,
               ULONG_MAX,
               ULONG_MAX,
               LONG_MIN,
               LONG_MAX,
               pliv,
               1.1, 1.1,
               1.1, 1.1,
               2.2, 2.2,
               2.2, 2.2,
               3.3, 3.3,
               3.3, 3.3,
               4.4, 4.4,
               4.4, 4.4);
  fprintf(out, "liv=%li\n\n", *pliv);



  fprintf(out, "Length modifier: \"ll\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a long long or unsigned long long argument;\n"
               "                 or that a following n conversion specifier applies to a pointer\n"
               "                 to a long long argument.\n"
               "arg: LONG_LONG_MAX   format string: \"%%lld\"   <%lld>\n"
               "arg: LONG_LONG_MIN   format string: \"%%lli\"   <%lli>\n"
               "arg: ULONG_LONG_MAX  format string: \"%%llo\"   <%llo>\n"
               "arg: ULONG_LONG_MAX  format string: \"%%llu\"   <%llu>\n"
               "arg: LONG_LONG_MIN   format string: \"%%llx\"   <%llx>\n"
               "arg: LONG_LONG_MAX   format string: \"%%llX\"   <%llX>\n"
               "arg: -               format string: \"%%lln\"   (pointer to lliv)%lln\n",
               LONG_LONG_MAX,
               LONG_LONG_MIN,
               ULONG_LONG_MAX,
               ULONG_LONG_MAX,
               LONG_LONG_MIN,
               LONG_LONG_MAX,
               plliv);
  fprintf(out, "lliv=%lli\n\n", *plliv);



  fprintf(out, "Length modifier: \"j\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to an intmax_t or uintmax_t argument; or that\n"
               "                 a following n conversion specifier applies to a pointer to an\n"
               "                 intmax_t argument.\n"
               "arg: LONG_LONG_MAX   format string: \"%%jd\"   <%jd>\n"
               "arg: LONG_LONG_MIN   format string: \"%%ji\"   <%ji>\n"
               "arg: ULONG_LONG_MAX  format string: \"%%jo\"   <%jo>\n"
               "arg: ULONG_LONG_MAX  format string: \"%%ju\"   <%ju>\n"
               "arg: LONG_LONG_MIN   format string: \"%%jx\"   <%jx>\n"
               "arg: LONG_LONG_MAX   format string: \"%%jX\"   <%jX>\n"
               "arg: -               format string: \"%%jn\"   (pointer to jiv)%jn\n",
               (intmax_t)LONG_LONG_MAX,
               (intmax_t)LONG_LONG_MIN,
               (uintmax_t)ULONG_LONG_MAX,
               (uintmax_t)ULONG_LONG_MAX,
               (intmax_t)LONG_LONG_MIN,
               (intmax_t)LONG_LONG_MAX,
               pjiv);
  fprintf(out, "jiv=%ji\n\n", *pjiv);



  fprintf(out, "Length modifier: \"z\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a size_t or the corresponding signed\n"
               "                 integer type argument; or that a following n conversion\n"
               "                 specifier applies to a pointer to a signed integer type\n"
               "                 corresponding to a size_t argument.\n"
               "arg: LONG_MAX    format string: \"%%zd\"   <%zd>\n"
               "arg: LONG_MIN    format string: \"%%zi\"   <%zi>\n"
               "arg: LONG_MAX    format string: \"%%zo\"   <%zo>\n"
               "arg: LONG_MAX    format string: \"%%zu\"   <%zu>\n"
               "arg: LONG_MIN    format string: \"%%zx\"   <%zx>\n"
               "arg: LONG_MAX    format string: \"%%zX\"   <%zX>\n"
               "arg: -           format string: \"%%zn\"   (pointer to ziv)%zn\n",
               (size_t)LONG_MAX,
               (size_t)LONG_MIN,
               (size_t)LONG_MAX,
               (size_t)LONG_MAX,
               (size_t)LONG_MIN,
               (size_t)LONG_MAX,
               pziv);
  fprintf(out, "ziv=%zi\n\n", *pziv);



  fprintf(out, "Length modifier: \"t\"\n"
               "                 Specifies that a following d, i, o, u, x, or X conversion\n"
               "                 specifier applies to a ptrdiff_t or the corresponding\n"
               "                 unsigned type argument; or that a following n conversion\n"
               "                 specifier applies to a pointer to a ptrdiff_t argument.\n"
               "arg: LONG_MAX    format string: \"%%td\"   <%td>\n"
               "arg: LONG_MIN    format string: \"%%ti\"   <%ti>\n"
               "arg: LONG_MAX    format string: \"%%to\"   <%to>\n"
               "arg: ULONG_MAX   format string: \"%%tu\"   <%tu>\n"
               "arg: LONG_MIN    format string: \"%%tx\"   <%tx>\n"
               "arg: LONG_MAX    format string: \"%%tX\"   <%tX>\n"
               "arg: -           format string: \"%%tn\"   (pointer to piv)%tn\n",
               (ptrdiff_t)LONG_MAX,
               (ptrdiff_t)LONG_MIN,
               (ptrdiff_t)LONG_MAX,
               (ptrdiff_t)ULONG_MAX,
               (ptrdiff_t)LONG_MIN,
               (ptrdiff_t)LONG_MAX,
               ppiv);
  fprintf(out, "piv=%ti\n\n", *ppiv);



  fprintf(out, "Length modifier: \"L\"\n"
               "---------1---------2---------3---------4---------5---------6---------7---------8\n"
               "                 Specifies that a following a, A, e, E, f, F, g, or G conversion\n"
               "                 specifier applies to a long double argument.\n"
#if TEST_LIBSUPP
               "arg: LDBL_MAX    format string: \"%%La\"   <%La>\n"
               "arg: LDBL_MIN    format string: \"%%LA\"   <%LA>\n"
#endif
               "arg: LDBL_MAX    format string: \"%%Le\"   <%Le>\n"
               "arg: LDBL_MIN    format string: \"%%LE\"   <%LE>\n"
               "arg: LDBL_MAX    format string: \"%%Lf\"   <%Lf>\n"
#if TEST_LIBSUPP
               "arg: LDBL_MIN    format string: \"%%LF\"   <%LF>\n"
#endif
               "arg: LDBL_MAX    format string: \"%%Lg\"   <%Lg>\n"
               "arg: LDBL_MIN    format string: \"%%LG\"   <%LG>\n\n",
               LDBL_MAX,
               LDBL_MIN,
               LDBL_MAX,
               LDBL_MIN,
               LDBL_MAX,
               LDBL_MIN,
               LDBL_MAX,
               LDBL_MIN);
}


void numeric_conversion_specifiers_test(FILE *out)
{
  int i, width, precision;
  double darg[] = {1.1, 2.2, 3.3};
  char *title[] = {"En castellano:", "Auf deutsch:", "In english:"};
  char *format[] = {
   "%5$s, %2$d de %1$s, %3$*6$.*7$d:%4$*6$.*7$d\n",
   "%5$s, %2$d. %1$s, %3$*6$.*7$d:%4$*6$.*7$d\n",
   "%5$s, %1$s %2$d, %3$*6$.*7$d:%4$*6$.*7$d\n"
  };
  char *weekday[] = {"Sabado", "Samstag", "Saturday"};
  char *month[] = {"febrero", "Februar", "february"};
  int day = 2;
  int hour = 12;
  int min = 34;


  fprintf(out, "\n\nTesting numeric conversion specifiers.\n"
               "======================================\n");

  width = 10;
  precision = 1;
  fprintf(out, "Printing a sequence of numbers using a given field width and precision\n"
               "accessing the variables a multiple times in different order.\n"
               "The sequence of arguments after the format string is:\n"
               "  width, precision, darg[0], darg[1], darg[2]\n"
               "with the values:\n"
               "  width:     %d\n"
               "  precision: %d\n"
               "  darg[0]:   %f\n"
               "  darg[1]:   %f\n"
               "  darg[2]:   %f\n",
               width, precision, darg[0], darg[1], darg[2]);
  fprintf(out, "Format string: \"%%3$-*1$.*2$f###%%4$*1$.*2$f###%%5$*1$.*2$f\"     <%3$-*1$.*2$f###%4$*1$.*2$f###%5$*1$.*2$f>\n"
               "Printing again but accessing the arguments in inverse order:\n"
               "Format string: \"%%5$-*1$.*2$f###%%4$*1$.*2$f###%%3$*1$.*2$f\"     <%5$-*1$.*2$f###%4$*1$.*2$f###%3$*1$.*2$f>\n\n\n",
               width, precision, darg[0], darg[1], darg[2]);


  width = 2;
  precision = 2;
  fprintf(out, "Printing Language-Independent Date and Time.\n\n");
  for (i = 0; i < 3; i++)
  {
    int len = strlen(format[i]);
    fprintf(out, "%s  ", title[i]);
    fprintf(out, format[i], month[i], day, hour, min, weekday[i], width, precision);
    format[i][--len] = '\0';
    fprintf(out, "Produced with:\n"
                 "  printf(\"%1$s\\n\", month[%2$i], day, hour, min, weekday[%2$i], width, precision);\n\n",
                 format[i], i);
  }
}


void printf_test(FILE *out)
{
  char buf[100], *strbuf;
  union {
    unsigned int word[3];
    long double value;
  } x;
  int strlng;



  fprintf(out, "\n\nGeneral test of the printf familiy of functions.\n"
               "================================================\n");

  fprintf(out, "Infinity.\n");
  sprintf(buf, "%La", 1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%La\"   arg: 1.0L / 0.0L\n"
               "Shall return: \"inf\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LA", -1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LA\"   arg: -1.0L / 0.0L\n"
               "Shall return: \"-INF\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Lf", 1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Lf\"   arg: 1.0L / 0.0L\n"
               "Shall return: \"inf\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LF", -1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LF\"   arg: -1.0L / 0.0L\n"
               "Shall return: \"-INF\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Le", 1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Le\"   arg: 1.0L / 0.0L\n"
               "Shall return: \"inf\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LE", -1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LE\"   arg: -1.0L / 0.0L\n"
               "Shall return: \"-INF\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Lg", 1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Lg\"   arg: 1.0L / 0.0L\n"
               "Shall return: \"inf\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LG", -1.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LG\"   arg: -1.0L / 0.0L\n"
               "Shall return: \"-INF\"   returns: \"%s\"\n\n", buf);

  fprintf(out, "NaN.\n");
  sprintf(buf, "%La", 0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%La\"   arg: 0.0L / 0.0L\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LA", -0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LA\"   arg: -0.0L / 0.0L\n"
               "Shall return: \"NAN\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Lf", 0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Lf\"   arg: 0.0L / 0.0L\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LF", -0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LF\"   arg: -0.0L / 0.0L\n"
               "Shall return: \"NAN\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Le", 0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Le\"   arg: 0.0L / 0.0L\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LE", -0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LE\"   arg: -0.0L / 0.0L\n"
               "Shall return: \"NAN\"   returns: \"%s\"\n", buf);
  sprintf(buf, "%Lg", 0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%Lg\"   arg: 0.0L / 0.0L\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", buf);
  sprintf(buf, "%LG", -0.0L / 0.0L);
  fprintf(out, "fmt str: \"%%LG\"   arg: -0.0L / 0.0L\n"
               "Shall return: \"NAN\"   returns: \"%s\"\n\n", buf);


  x.word[2] = 0x7FFF;
  x.word[1] = 0xC000000C;
  x.word[0] = 0x10000001;
  fprintf(out, "Quiet NaN\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0x7FFF;
  x.word[1] = 0x80000008;
  x.word[0] = 0x10000001;
  fprintf(out, "Signalling NaN\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0x7FFF;
  x.word[1] = 0x40000004;
  x.word[0] = 0x10000001;
  fprintf(out, "Pseudo-NaN\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0xFFFF;
  x.word[1] = 0x00000000;
  x.word[0] = 0x00000000;
  fprintf(out, "Pseudo-Infinity\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0x4004;
  x.word[1] = 0x00000000;
  x.word[0] = 0x00000000;
  fprintf(out, "Pseudo-Zero\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0x0440;
  x.word[1] = 0x60000006;
  x.word[0] = 0x10000001;
  fprintf(out, "Unnormalized number\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);
  x.word[2] = 0x0000;
  x.word[1] = 0x80000008;
  x.word[0] = 0x10000001;
  fprintf(out, "Pseudo-Denormal\n");
  sprintf(buf, "%La", x.value);
  fprintf(out, "fmt str: \"%%La\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Le", x.value);
  fprintf(out, "fmt str: \"%%Le\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lf", x.value);
  fprintf(out, "fmt str: \"%%Lf\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n", x.word[2], x.word[1], x.word[0], buf);
  sprintf(buf, "%Lg", x.value);
  fprintf(out, "fmt str: \"%%Lg\"   exp: %#.4x  manthi: %#.8x  mantlo: %#.8x\n"
               "Shall return: \"nan\"    returns: \"%s\"\n\n", x.word[2], x.word[1], x.word[0], buf);


  fprintf(out, "Testing asprintf.\n");
  fprintf(out, "Code line:   strlng = asprintf(&strbuf, \"Pi = %%.15Lf\", 3.1415926535897932384626433832795L);\n");
  strlng = asprintf(&strbuf, "Pi = %.15Lf", 3.1415926535897932384626433832795L);
  fprintf(out, "Result:      strbuf: \"%s\"   strlng: %d\n", strbuf, strlng);
  free(strbuf);

  fprintf(out, "Testing asnprintf.\n");
  strbuf = NULL;
  fprintf(out, "Code line:   strlng = asnprintf(&strbuf, 0, \"Pi = %%.15Lf\", 3.1415926535897932384626433832795L);\n");
  strlng = asnprintf(&strbuf, 0, "Pi = %.15Lf", 3.1415926535897932384626433832795L);
  fprintf(out, "Result:      strbuf: %s  strlng: %d\n", strbuf, strlng);
  fprintf(out, "Code line:   strlng = asnprintf(&strbuf, 10, \"Pi = %%.15Lf\", 3.1415926535897932384626433832795L);\n");
  strlng = asnprintf(&strbuf, 10, "Pi = %.15Lf", 3.1415926535897932384626433832795L);
  fprintf(out, "Result:      strbuf: 0x%p  strlng: %d\n", strbuf, strlng);
  fprintf(out, "             strbuf: \"%s\"  mallocated buffer length is %zd chars long plus 1 nul char\n\n", strbuf, strlen(strbuf));
  free(strbuf);

  fprintf(out, "Testing flags in combination with Infinity and NaN.\n");
  fprintf(out, "Code line:   sprintf(buf, \"%%0*Lf\", 10, 1.0L / 0.0L);\n");
  sprintf(buf, "%0*Lf", 10, 1.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "inf");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%+*Lf\", 10, 1.0L / 0.0L);\n");
  sprintf(buf, "%+*Lf", 10, 1.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "+inf");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%-*Lf\", 10, 1.0L / 0.0L);\n");
  sprintf(buf, "%-*Lf", 10, 1.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "inf       ");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%% *Lf\", 10, 1.0L / 0.0L);\n");
  sprintf(buf, "% *Lf", 10, 1.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "inf");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%#*Lf\", 10, 1.0L / 0.0L);\n");
  sprintf(buf, "%#*Lf", 10, 1.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "inf");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%0*Lf\", 10, 0.0L / 0.0L);\n");
  sprintf(buf, "%0*Lf", 10, 0.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "nan");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%+*Lf\", 10, 0.0L / 0.0L);\n");
  sprintf(buf, "%+*Lf", 10, 0.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "+nan");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%-*Lf\", 10, 0.0L / 0.0L);\n");
  sprintf(buf, "%-*Lf", 10, 0.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "nan       ");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%% *Lf\", 10, 0.0L / 0.0L);\n");
  sprintf(buf, "% *Lf", 10, 0.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "nan");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
  fprintf(out, "Code line:   sprintf(buf, \"%%#*Lf\", 10, 0.0L / 0.0L);\n");
  sprintf(buf, "%#*Lf", 10, 0.0L / 0.0L);
  asprintf(&strbuf, "%*s", (int)strlen(buf), "nan");
  fprintf(out, "Shall return: <%s>    returns: <%s>  %s\n", strbuf, buf, strcmp(strbuf, buf) ? "Not OK" : "OK");
  free(strbuf);
}


void signbit_test(FILE *out)
{
  fprintf(out, "\n\nTest of signbit and internal implementations.\n"
               "=============================================\n");

  fprintf(out, "signbit(%+.1fF):     %d\n"
               "__signbitf(%+.1fF):  %d\n",  0.0F, signbit(0.0F), -0.0F, __signbitf(-0.0F));
  fprintf(out, "signbit(%+.1f):      %d\n"
               "__signbitd(%+.1f):   %d\n",  0.0, signbit(0.0), -0.0, __signbitd(-0.0));
  fprintf(out, "signbit(%+.1LfL):     %d\n"
               "__signbitld(%+.1LfL): %d\n", 0.0L, signbit(0.0L), -0.0L, __signbitld(-0.0L));
}


#define BUFFER1 "TEXT TO BE APPENDED"
#define BUFFER2 "NEW:TEST:STRING"
#define BUFFER3 "TAIL"
#define BUFFER4 "CENTRAL"
#define BUFFER5 "HEAD"
#define BUFFER  ""

void print_result(FILE *out, char *argz, size_t argz_len)
{
  size_t index, len;


  fprintf(out, "argz_len: %zd\n", argz_len);
  if (argz_len)
    for (index = 0; index < argz_len;)
    {
      fprintf(out, "argz[%zd] = <", index);
      len = index;
      index += fprintf(out, "%s", argz + index);
      fprintf(out, "\\0>\t\tlength = %zd\n", ++index - len);
    }
  else
    fprintf(out, "argz[0] = %s", argz);
}


void argz_test(FILE *out)
{
  char *const glibc_compatibility_test_argv[] = {
    NULL
  };
  char *glibc_compatibility_test_string = "";
  char *const test_argv[] = {
    "Test",
    "string",
    "for",
    "argz_create",
    NULL
  };
  const char *test_string1 = "Test#string#1# #for#argz_create_sep#";
  const char *test_string2 = "Test#string#2# #for#argz_create_sep";
  const char *test_string3 = "TO BE REPLACED#string 1#TO BE REPLACED#string 2#string 3#TO BE REPLACED#string 4#string 5#TO BE REPLACED";
  int delimiter = '#';
  char *argz, **argvp = NULL, *before, *entry;
  size_t argz_len, counts, entry_index, i;
  error_t error;


  fprintf(out, "\n\nTest of argz family of functions.\n"
               "=================================\n");


  /*
   *  argz_create test.
   */
  fprintf(out, "Test: argz_create.\n"
               "==================\n"
               "An argz vector shall be created using the following UNIX-style argv array:\n");
  for (i = 0; test_argv[i]; i++)
    fprintf(out, "test_argv[%zi]: \"%s\"\n", i, test_argv[i]);
  fprintf(out, "test_argv[%zi]: \"%s\"\n", i, test_argv[i]);
  fprintf(out, "\n");

  error = argz_create(test_argv, &argz, &argz_len);
  if (error)
  {
    fprintf(out, "argz_create test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "argz_create test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_count test.
   */
  fprintf(out, "Test: argz_count.\n"
               "=================\n"
               "Count the strings contained in an argz vector.\n");
  for (counts = 0; test_argv[counts]; counts++)
    ;
  if (counts != argz_count(argz, argz_len))
  {
    fprintf(out, "argz_count test failed.\n");
    exit(1);
  }
  else
  {
    fprintf(out, "\nargz_count test passed.\n");
    fprintf(out, "counts: %zd\n", counts);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_create_sep test.
   */
  fprintf(out, "Test 1: argz_create_sep.\n"
               "========================\n"
               "An argz vector shall be created using the following test string:\n"
               "\"%s\"\n"
               "The delimiter character \'%c\' will be used as string separator\n"
               "in the test string and will be replaced with \'\\0\' in the argz vector.\n", test_string1, delimiter);
  free(argz);
  error = argz_create_sep(test_string1, delimiter, &argz, &argz_len);
  if (error)
  {
    fprintf(out, "\nargz_create_sep test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_create_sep test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n");

  fprintf(out, "Test 2: argz_create_sep.\n"
               "========================\n"
               "An argz vector shall be created using the following test string:\n"
               "\"%s\"\n"
               "The delimiter character \'%c\' will be used as string separator\n"
               "in the test string and will be replaced with \'\\0\' in the argz vector.\n", test_string2, delimiter);
  free(argz);
  error = argz_create_sep(test_string2, delimiter, &argz, &argz_len);
  if (error)
  {
    fprintf(out, "argz_create_sep failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_create_sep test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_add test.
   */
  fprintf(out, "Test: argz_add.\n"
               "===============\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be added to the end of an argz vector.\n", BUFFER1);
  entry_index = argz_len;  /*  Remember the position of the entry that later will be deleted.  */
  error = argz_add(&argz, &argz_len, BUFFER1);
  if (error)
  {
    fprintf(out, "\nargz_add test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_add test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_add_sep test.
   */
  delimiter = ':';
  fprintf(out, "Test: argz_add_sep.\n"
               "===================\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be added to the end of an argz vector.\n"
               "The delimiter character \'%c\' will be used as string separator\n"
               "in the test string and will be replaced with \'\\0\' in the argz vector.\n", BUFFER2, delimiter);
  error = argz_add_sep(&argz, &argz_len, BUFFER2, delimiter);
  if (error)
  {
    fprintf(out, "\nargz_add_sep test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_add_sep test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_delete test.
   */
  fprintf(out, "Test: argz_delete.\n"
               "==================\n"
               "The entry:\n"
               "\"%s\"\n"
               "will be deleted from argz vector.\n", BUFFER1);
  argz_delete(&argz, &argz_len, argz + entry_index);
  fprintf(out, "\nargz_delete test passed.\n");
  print_result(out, argz, argz_len);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_append test.
   */
  fprintf(out, "Test: argz_append.\n"
               "==================\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be appended to the end of an argz vector.\n", BUFFER1);
  error = argz_append(&argz, &argz_len, BUFFER1, sizeof(BUFFER1));
  if (error)
  {
    fprintf(out, "\nargz_append test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_append test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_extract test.
   */
  fprintf(out, "Test: argz_extract.\n"
               "===================\n"
               "Store pointers to each string contained in the argz vector in an UNIX-style argv array,\n"
               "which must be large enough to contain them inclusive the terminating NULL pointer.\n");
  counts = argz_count(argz, argz_len) + 1;
  argvp = malloc(counts * sizeof(*argvp));
  fprintf(out, "\nargz_extract test passed.\n");
  argz_extract(argz, argz_len, argvp);
  fprintf(out, "argz_len: %zd\n", argz_len);
  for (i = 0; i < counts; i++)
    fprintf(out, "argvp[%zi]: \"%s\"\n", i, argvp[i]);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_next test.
   */
  fprintf(out, "Test: argz_next.\n"
               "================\n"
               "Get a pointer to the next entry in the argz vector after the entry passed to the function.\n");
  fprintf(out, "\nargz_extract test passed.\n");
  entry = NULL;
  do {
    fprintf(out, "entry passed (0x%p):  \"%s\"\t\t", entry, entry);
    entry = argz_next(argz, argz_len, entry);
    fprintf(out, "entry returned (0x%p):  \"%s\"\n", entry, entry);
  } while (entry);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_insert test.
   */
  fprintf(out, "Test: argz_insert.\n"
               "==================\n"
               "Insert entry in the argz vector before the string pointed by the pointer passed to the function.\n");
  before = NULL;
  error = argz_insert(&argz, &argz_len, before, BUFFER3);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nFirst argz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  thus  entry \"%s\" will be appended at the end of argz.\n", before, before, BUFFER3);
    print_result(out, argz, argz_len);
  }
  before = argz + entry_index;
  entry = strdup(before);
  error = argz_insert(&argz, &argz_len, before, BUFFER4);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nSecond argz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  >  argz (0x%p): \"%s\"  thus  entry \"%s\" will be inserted before \"%s\".\n", entry, entry, argz, argz, BUFFER4, entry);
    print_result(out, argz, argz_len);
  }
  free(entry);
  before = argz;
  error = argz_insert(&argz, &argz_len, before, BUFFER5);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nThird argz_insert test passed.\n");
    fprintf(out, "before (0x%p) == argz (0x%p)  thus  entry \"%s\" will be inserted before the beginnig of argz.\n", before, argz, BUFFER5);
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_stringify test.
   */
  delimiter = '/';
  fprintf(out, "Test: argz_stringify.\n"
               "=====================\n"
               "Make a '\\0' separated argz vector printable by converting all the '\\0's\n"
               "except the last into the character '%c'.\n", delimiter);
  argz_stringify(argz, argz_len, delimiter);
  fprintf(out, "\nargz_stringify test passed.\n");
  print_result(out, argz, argz_len);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_replace test.
   */
  free(argz);
  error = argz_create_sep(test_string3, '#', &argz, &argz_len);
  if (error)
  {
    fprintf(out, "argz_create_sep failed: ENOMEM\n");
    exit(error);
  }
  entry = malloc(argz_len);
  memcpy(entry, argz, argz_len);
  argz_stringify(argz, argz_len, '/');
  fprintf(out, "Test: argz_replace.\n"
               "===================\n"
               "Replace any occurrences of string:\n"
               "\"%s\"\n"
               "in the argz vector:\n"
               "\"%s\"\n"
               "with:\n"
               "\"%s\",\n"
               "reallocating the argz vector as necessary.\n", "TO BE REPLACED", argz, "REPLACEMENT STRING");
  free(argz);
  argz = entry;
  error = argz_replace(&argz, &argz_len, "TO BE REPLACED", "REPLACEMENT STRING", NULL);
  if (error)
  {
    fprintf(out, "\nargz_replace test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_replace test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");




  /*
   *
   *  The same test but with (NULL, 0) to check if no SIGSEGV happens.
   *
   */
  free(argz);
  fprintf(out, "#\n#\n#\n#  The same tests but with an argz vector of the form (NULL, 0).\n#\n#\n#\n\n\n");

  /*
   *  argz_create test.
   */
  fprintf(out, "Test: argz_create.\n"
               "==================\n"
               "An argz vector shall be created using the following argv array:\n");
  for (i = 0; glibc_compatibility_test_argv[i]; i++)
    fprintf(out, "test_argv[%zi]: \"%s\"\n", i, glibc_compatibility_test_argv[i]);
  fprintf(out, "test_argv[%zi]: \"%s\"\n", i, glibc_compatibility_test_argv[i]);
  fprintf(out, "\n");

  error = argz_create(glibc_compatibility_test_argv, &argz, &argz_len);
  if (error)
  {
    fprintf(out, "argz_create test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "argz_create test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_create_sep test.
   */
  fprintf(out, "Test: argz_create_sep.\n"
               "======================\n"
               "An argz vector shall be created using the following test string:\n"
               "\"%s\"\n"
               "The delimiter character \'%c\' will be used as string separator\n"
               "in the test string and will be replaced with \'\\0\' in the argz vector.\n", glibc_compatibility_test_string, delimiter);
  error = argz_create_sep(glibc_compatibility_test_string, delimiter, &argz, &argz_len);
  if (error)
  {
    fprintf(out, "\nargz_create_sep test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_create_sep test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_count test.
   */
  fprintf(out, "Test: argz_count.\n"
               "=================\n"
               "Count the strings contained in an argz vector.\n");
  for (counts = 0; glibc_compatibility_test_argv[counts]; counts++)
    ;
  if (counts != argz_count(argz, argz_len))
  {
    fprintf(out, "argz_count test failed.\n");
    exit(1);
  }
  else
  {
    fprintf(out, "\nargz_count test passed.\n");
    fprintf(out, "counts: %zd\n", counts);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_add test.
   */
  fprintf(out, "Test: argz_add.\n"
               "===============\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be added to the end of an argz vector.\n", BUFFER);
  entry_index = argz_len;  /*  Remember the position of the entry that later will be deleted.  */
  error = argz_add(&argz, &argz_len, BUFFER);
  if (error)
  {
    fprintf(out, "\nargz_add test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_add test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_add_sep test.
   */
  delimiter = ':';
  fprintf(out, "Test: argz_add_sep.\n"
               "======================\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be added to the end of an argz vector.\n"
               "The delimiter character \'%c\' will be used as string separator\n"
               "in the test string and will be replaced with \'\\0\' in the argz vector.\n", BUFFER, delimiter);
  error = argz_add_sep(&argz, &argz_len, BUFFER, delimiter);
  if (error)
  {
    fprintf(out, "\nargz_add_sep test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_add_sep test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_delete test.
   */
  fprintf(out, "Test: argz_delete.\n"
               "==================\n"
               "The entry:\n"
               "\"%s\"\n"
               "will be deleted from argz vector.\n", BUFFER);
  argz_delete(&argz, &argz_len, argz + entry_index);
  fprintf(out, "\nargz_delete test passed.\n");
  fprintf(out, "argz_len: %zd\n", argz_len);
  fprintf(out, "argz:     %s\n", argz);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_append test.
   */
  fprintf(out, "Test: argz_append.\n"
               "==================\n"
               "The test string:\n"
               "\"%s\"\n"
               "shall be appended to the end of an argz vector.\n", BUFFER);
  error = argz_append(&argz, &argz_len, BUFFER, sizeof(BUFFER));
  if (error)
  {
    fprintf(out, "\nargz_append test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_append test passed.\n");
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_extract test.
   */
  fprintf(out, "Test: argz_extract.\n"
               "===================\n"
               "Store pointers to each string contained in the argz vector in an argv array,\n"
               "which must be large enough to contain them inclusive the terminating NULL pointer.\n");
  error = argz_add(&argz, &argz_len, BUFFER);
  error = argz_add(&argz, &argz_len, BUFFER);
  error = argz_add(&argz, &argz_len, BUFFER);
  error = argz_add(&argz, &argz_len, BUFFER);
  counts = argz_count(argz, argz_len) + 1;
  argvp = malloc(counts * sizeof(*argvp));
  fprintf(out, "\nargz_extract test passed.\n");
  argz_extract(argz, 0, argvp);
  fprintf(out, "argz_len=0\n");
  fprintf(out, "argvp[0]: \"%s\"\n", argvp[0]);
  fprintf(out, "\n");
  argz_extract(argz, 1, argvp);
  fprintf(out, "argz_len=1\n");
  for (i = 0; i < 2; i++)
    fprintf(out, "argvp[%zi]: \"%s\"\n", i, argvp[i]);
  fprintf(out, "\n");
  argz_extract(argz, argz_len, argvp);
  fprintf(out, "argz_len: %zd\n", argz_len);
  for (i = 0; i < counts; i++)
    fprintf(out, "argvp[%zi]: \"%s\"\n", i, argvp[i]);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_next test.
   */
  fprintf(out, "Test: argz_next.\n"
               "================\n"
               "Get a pointer to the next entry in the argz vector after the entry passed to the function.\n");
  fprintf(out, "\nargz_extract test passed.\n");
  entry = NULL;
  do {
    fprintf(out, "entry passed (0x%p):  \"%s\"\t\t", entry, entry);
    entry = argz_next(argz, argz_len, entry);
    fprintf(out, "entry returned (0x%p):  \"%s\"\n", entry, entry);
  } while (entry);
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_insert test.
   */
  fprintf(out, "Test 1: argz_insert.\n"
               "====================\n"
               "Insert entry in the argz vector before the string pointed by the pointer passed to the function.\n");
  before = NULL;
  error = argz_insert(&argz, &argz_len, before, BUFFER);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  thus  entry \"%s\" will be appended at the end of argz.\n", before, before, BUFFER);
    print_result(out, argz, argz_len);
  }
  before = argz + argz_len / 2;
  entry = strdup(before);
  error = argz_insert(&argz, &argz_len, before, BUFFER);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  >  argz (0x%p): \"%s\"  thus  entry \"%s\" will be inserted before \"%s\".\n", entry, entry, argz, argz, BUFFER, entry);
    print_result(out, argz, argz_len);
  }
  free(entry);
  before = argz;
  error = argz_insert(&argz, &argz_len, before, BUFFER);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p) == argz (0x%p)  thus  entry \"%s\" will be inserted before the beginnig of argz.\n", before, argz, BUFFER);
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_insert test.
   */
  fprintf(out, "Test 2: argz_insert.\n"
               "==================\n"
               "Insert entry in the argz vector before the string pointed by the pointer passed to the function.\n");
  before = NULL;
  error = argz_insert(&argz, &argz_len, before, BUFFER3);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  thus  entry: \"%s\" will be appended to the end of argz.\n", before, before, BUFFER3);
    print_result(out, argz, argz_len);
  }
  before = argz + argz_len / 2;
  entry = strdup(before);
  error = argz_insert(&argz, &argz_len, before, BUFFER4);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p): \"%s\"  >  argz (0x%p): \"%s\"  thus  entry: \"%s\" will be inserted before \"%s\".\n", entry, entry, argz, argz, BUFFER4, entry);
    print_result(out, argz, argz_len);
  }
  free(entry);
  before = argz;
  error = argz_insert(&argz, &argz_len, before, BUFFER5);
  if (error)
  {
    fprintf(out, "\nargz_insert test failed: ENOMEM\n");
    exit(error);
  }
  else
  {
    fprintf(out, "\nargz_insert test passed.\n");
    fprintf(out, "before (0x%p) == argz (0x%p)  thus  entry (0x%p): \"%s\" will be inserted before the beginnig of argz.\n", before, argz, BUFFER5, BUFFER5);
    print_result(out, argz, argz_len);
  }
  fprintf(out, "\n################################################################################\n\n\n");


  /*
   *  argz_stringify test.
   */
  delimiter = '/';
  fprintf(out, "Test: argz_stringify.\n"
               "=====================\n"
               "Make a '\\0' separated argz vector printable by converting all the '\\0's\n"
               "except the last into the character '%c'.\n", delimiter);
  argz_stringify(argz, argz_len, delimiter);
  fprintf(out, "\nargz_stringify test passed.\n");
  print_result(out, argz, argz_len);
  fprintf(out, "\n################################################################################\n\n\n");
}


void fixpath_and_realpath_test(FILE *out)
{
#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  fprintf(out, "\n\nTest of fixpath and realpath.\n"
               "=============================\n");
#else
  fprintf(out, "\n\nTest of fixpath.\n"
               "================\n");
#endif

  char *old_path = ".\\foo\\bar///";
  char new_path[FILENAME_MAX];
  char *this_dir;


  /*
   *  The broken version of _fixpath/realpath
   *  only fails if the CWD is the root dir.
   */
  this_dir = getcwd(NULL, FILENAME_MAX);
  if (!this_dir)
  {
    fprintf(out, "getcwd failed.\n");
    return;
  }
  if (errno = 0, chdir("/"))
  {
    fprintf(out, "Cannot chdir to root dir (errno=%d).\n", errno);
    goto finished;
  }

  errno = 0;
  _fixpath(old_path, new_path);
  if (errno == ENAMETOOLONG)
  {
    fprintf(out, "fixpath failed with ENAMETOOLONG.\n");
    goto finished;
  }
  fprintf(out, "fixpath test:\n"
               "old path=%s\n"
               "new path=%s\n", old_path, new_path);
  
#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  errno = 0;
  realpath(old_path, new_path);
  if (errno == ENAMETOOLONG)
  {
    fprintf(out, "realpath failed with ENAMETOOLONG.\n");
    goto finished;
  }
  fprintf(out, "\nrealpath test:\n"
               "old path=%s\n"
               "new path=%s\n", old_path, new_path);
#endif

finished:
  if (errno = 0, chdir(this_dir))
  {
    fprintf(out, "Cannot chdir to \"%s\" (errno=%d).\n", this_dir, errno);
    exit(1);
  }
  free(this_dir);
}


void lstat_and_stat_test(FILE *out)
{
#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  fprintf(out, "\n\nTest of lstat.\n"
               "==============\n");
#else
  fprintf(out, "\n\nTest of stat.\n"
               "================\n");
#endif

  struct stat s;
  char *this_dir;
  int e, r;


  /*
   *  The broken version of lstat or stat
   *  only fails if the CWD is the root dir.
   */
  this_dir = getcwd(NULL, FILENAME_MAX);
  if (!this_dir)
  {
    fprintf(out, "getcwd failed.\n");
    return;
  }
  if (errno = 0, chdir("/"))
  {
    fprintf(out, "Cannot chdir to root dir (errno=%d).\n", errno);
    goto finished;
  }

  errno = 0;
#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  r = lstat(".", &s);
#else
  r = stat(".", &s);
#endif
  e = errno;

  if (r)
    fprintf(out, "lstat/stat failed with return value = %d and errno = %d.\n", r, e);
  else
    fprintf(out, "lstat/stat passed with return value = %d and errno = %d.\n", r, e);

finished:
  if (errno = 0, chdir(this_dir))
  {
    fprintf(out, "Cannot chdir to \"%s\" (errno=%d).\n", this_dir, errno);
    exit(1);
  }
  free(this_dir);
}


void strlcat_and_strlcpy_test(FILE *out)
{
#define I_MAX 4

  char *src = "string";
  char dst[10] = "";
  int i;
  size_t len, size[I_MAX] = {10, 5, 1, 0};

  fprintf(out, "\n\nTest of strlcat and strlcpy.\n"
               "============================\n");

  fprintf(out, "Testing:  len = strlcpy(dst, src, size);\n");
  for (i = 0; i < I_MAX; i++)
  {
    fprintf(out, "src = \"%s\"   dst = \"%s\"   ", src, dst);
    len = strlcpy(dst, src, size[i]);
    fprintf(out, "res = \"%s\"   size = %zu   len = %zu\n", dst, size[i], len);
  }
  src[0] = 'x'; src[1] = ' '; src[2] = '\0';
  dst[0] = 's'; dst[1] = 't'; dst[2] = 'r'; dst[3] = 'i'; dst[4] = 'n'; dst[5] = 'g'; dst[6] = '\0';
  fprintf(out, "src = \"%s\"   dst = \"%s\"   ", src, dst);
  len = strlcpy(dst, src, 3);
  fprintf(out, "res = \"%s\"   size = %u   len = %zu\n", dst, 3, len);
  src[0] = 'x'; src[1] = ' '; src[2] = '\0';
  dst[0] = 'a'; dst[1] = ' '; dst[2] = 's'; dst[3] = 't'; dst[4] = 'r'; dst[5] = 'i'; dst[6] = 'n'; dst[7] = 'g'; dst[8] = '\0';
  fprintf(out, "src = \"%s\"   dst = \"%s\"   ", src, dst);
  len = strlcpy(dst, src, 10);
  fprintf(out, "res = \"%s\"   size = %u   len = %zu\n", dst, 10, len);
}


void memmem_test(FILE *out)
{
#define LENGTH_OF(s)      (sizeof(s) - 1)  /*  Without the terminating zero.  */

#define HAYSTACK_STRING   "\0001234567890\xB0"
#define HAYSTACK_LENGTH   LENGTH_OF(HAYSTACK_STRING)


  typedef const struct {
    const char   *str;
    const size_t  len;
  } substring_t;
  substring_t needle[] = {
    {"456",       LENGTH_OF("456")},
    {"\00012",    LENGTH_OF("\00012")},
    {"90\xB0",    LENGTH_OF("90\xB0")},
    {"ABC",       LENGTH_OF("ABC")},
    {"0\xB0\000", LENGTH_OF("0\xB0\000")},
    {"\xB0",      LENGTH_OF("\xB0")},
    {NULL,  0}
  };
  char *begin;
  const char haystack[HAYSTACK_LENGTH + 1] = HAYSTACK_STRING;
  int i;

  fprintf(out, "\n\nTest of memmem.\n"
               "===============\n");

  for (i = 0; needle[i].str; i++)
  {
    int j;

    fprintf(out, "Searching for \"");
    for (j = 0; j < needle[i].len; j++)
      if (needle[i].str[j] != '\0')
        fprintf(out, "%c", needle[i].str[j]);
      else
        fprintf(out, "\\0");
    fprintf(out, "\" in \"");
    for (j = 0; j < HAYSTACK_LENGTH; j++)
      if (haystack[j] != '\0')
        fprintf(out, "%c", haystack[j]);
      else
        fprintf(out, "\\0");
    fprintf(out, "\":  ");
    if ((begin = memmem(haystack, HAYSTACK_LENGTH, needle[i].str, needle[i].len)))
      fprintf(out, "found at position %u.\n", begin - haystack);
    else
      fprintf(out, "not found.\n");
  }
}


void mbtowc_test(FILE *out)
{
  int ret_value;
  fprintf(out, "\n\nTest of mb/wc family of functions.\n"
               "==================================\n");

  /*  Testing mblen.  */
  ret_value = mblen(NULL, 1);
  if (ret_value != 0)
    fprintf(out, "mblen(NULL, 1) should return 0 but returned %d.\n", ret_value);
  else
  {
    ret_value = mblen("", 1);
    if (ret_value != 0)
      fprintf(out, "mblen(\"\", 1) should return 0 but returned %d.\n", ret_value);
    else
    {
      char *string = "FOOBAR";
      ret_value = mblen(string, 0);
      if (ret_value != -1)
        fprintf(out, "mblen(\"%s\", 0) should return -1 but returned %d.\n", string, ret_value);
      else
      {
        ret_value = mblen(string, 1);
        if (ret_value != 1)
          fprintf(out, "mblen(\"%s\", 1) should return 1 but returned %d.\n", string, ret_value);
        else
        {
          /*  Testing mbtowc.  */
          ret_value = mbtowc(NULL, NULL, 0);
          if (ret_value != 0)
            fprintf(out, "mbtowc(NULL, NULL, 0) should return 0 but returned %d.\n", ret_value);
          else
          {
            ret_value = mbtowc(NULL, string, 0);
            if (ret_value != -1)
              fprintf(out, "mbtowc(NULL, \"%s\", 0) should return -1 but returned %d.\n", string, ret_value);
            else
            {
              ret_value = mbtowc(NULL, string, 1);
              if (ret_value != 0)
                fprintf(out, "mbtowc(NULL, \"%s\", 1) should return 0 but returned %d.\n", string, ret_value);
              else
              {
                wchar_t awc[8];
                ret_value = mbtowc(awc, string, 1);
                if (ret_value != 1)
                  fprintf(out, "mbtowc(\"%ls\", \"%s\", 1) should return 1 but returned %d.\n", awc, string, ret_value);
                else
                {
                  /*  Testing mbsinit.  */
                  mbstate_t mbs;
                  ret_value = mbsinit(NULL);
                  if (ret_value != 1)
                    fprintf(out, "mbsinit(NULL) should return 1 but returned %d.\n", ret_value);
                  else
                  {
                    mbs.__count = 0;
                    ret_value = mbsinit(&mbs);
                    if (ret_value != 1)
                      fprintf(out, "mbsinit(&mbs) should return 1 but returned %d.\n", ret_value);
                    else
                    {
                      mbs.__count = 1;
                      ret_value = mbsinit(&mbs);
                      if (ret_value != 0)
                        fprintf(out, "mbsinit(&mbs) should return 0 but returned %d.\n", ret_value);
                      else
                      {
                        /*  Testing mbrtowc.  */
                        ret_value = mbrtowc(awc, NULL, 1, &mbs);
                        if (ret_value != 0)
                          fprintf(out, "mbrtowc(\"%ls\", NULL, 1, &mbs) should return 0 but returned %d.\n", awc, ret_value);
                        else
                        {
                          ret_value = mbrtowc(awc, string, 1, &mbs);
                          if (ret_value != 1)
                            fprintf(out, "mbrtowc(\"%ls\", \"%s\", 1, &mbs) should return 1 but returned %d.\n", awc, string, ret_value);
                          else
                            fprintf(out, "All tests passed.\n");
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
}


void scanf_test(FILE *out)
{
#define BUFFER_LENGTH  32
#define PI             3.1415926535897932384626433832795L
#define EULER          2.7182818284590452353602874713527L

  char buffer[BUFFER_LENGTH];
  long double test_out, test_in = PI;


  fprintf(out, "\n\nTest of %%A and %%a support of the scanf family of functions.\n"
               "===========================================================\n");

  snprintf(buffer, BUFFER_LENGTH, "%.15LA%c", test_in, '\0');
  sscanf(buffer, "%La", &test_out);
  if (test_in != test_out)
    fprintf(out, "Test value = 3.1415926535897932384626433832795L\nscanf(\"%%LA\") should have got %.15LA but got %.15LA.\n", test_in, test_out);
  else
  {
    test_in = EULER;
    snprintf(buffer, BUFFER_LENGTH, "%.15LA %c", test_in, '\0');
    sscanf(buffer, "%LA", &test_out);
    if (test_in != test_out)
      fprintf(out, "Test value = 2.7182818284590452353602874713527L\nscanf(\"%%LA\") should have got %.15LA but got %.15LA.\n", test_in, test_out);
    else
      fprintf(out, "All tests passed.\n");
  }
}


void open_test(FILE *out)
{
  const char *filename = "foobar.dir";
  const char *filename_with_slash = "foobar.dir/";
  int fd;

  fprintf(out, "\n\nTest of POSIX conforming behaviour of open for pathnames with trailing slash.\n"
               "=============================================================================\n");

  fd = open(filename, O_CREAT | O_WRONLY | O_RDWR);
  close(fd);
  
  errno = 0;
  fd = open(filename_with_slash, O_CREAT | O_WRONLY | O_RDWR);
  if (fd != -1)
    fprintf(out, "Test failed - unexpected open() success writing to file \"%s\"\n", filename_with_slash);
  if (errno != EISDIR)
    fprintf(out, "Test failed - wrong errno returned: %s\n", strerror(errno));

  fd = open(filename_with_slash, O_RDONLY);
  if (fd != -1)
    fprintf(out, "Test failed - unexpected open() success reading from file \"%s\"\n", filename_with_slash);
  if (errno != ENOTDIR)
    fprintf(out, "Test failed - wrong errno returned: %s\n", strerror(errno));

  fd = open("", O_RDONLY);
  if (fd != -1)
    fprintf(out, "Test failed - unexpected open() success reading from dir \"\"\n");
  if (errno != EINVAL)
    fprintf(out, "Test failed - wrong errno returned: %s\n", strerror(errno));

  fprintf(out, "All tests passed.\n");
  unlink(filename);
}


void fopen_freopen_fflush_fseek_ftell_fclose_rewind_test(FILE *out)
{
  FILE *test_file;
  long value;


  fprintf(out, "\n\nTest of fopen/freopen/fflush/fseek/ftell/fclose/rewind.\n"
               "=======================================================\n");
  errno = 0;
  test_file = fopen("./tfile1.txt", "w");
  if (!test_file)
  {
    fprintf(out, "File opening failed with errno =%d\n", errno);
    return;
  }

  fprintf(test_file, "123456foobar");

  errno = 0;
  rewind(test_file);
 
  fprintf(test_file, "raboof");

  errno = 0;
  value = fflush(test_file);
  if (value)
  {
    fprintf(out, "File flushing failed with errno =%d\n", errno);
    return;
  }

  errno = 0;
  test_file = freopen("./tfile2.txt", "w", test_file);
  if (!test_file)
  {
    fprintf(out, "File reopening failed with errno =%d\n", errno);
    return;
  }

  errno = 0;
  value = ftell(test_file);
  if (value == -1)
  {
    fprintf(out, "File telling failed with errno =%d\n", errno);
    return;
  }
  errno = 0;
  value = fseek(test_file, 6, SEEK_SET);
  if (value)
  {
    fprintf(out, "File seeking failed with errno =%d\n", errno);
    return;
  }
  fprintf(test_file, "XYZ");

  errno = 0;
  value = fclose(test_file);
  if (value)
  {
    fprintf(out, "File closing failed with errno =%d\n", errno);
    return;
  }

  fprintf(out, "All tests passed.\n");
  unlink("./tfile2.txt");
  unlink("./tfile1.txt");
}


int main(void)
{
  FILE *out;

  out = fopen("test.txt", "w");
  if (out == NULL)
  {
    printf("Can not open test.txt.  Test failed.\n");
    return 1;
  }

  printf("Testing:\n"
         "  printf family of functions...\n");
  flags_test(out);
  length_modifiers_test(out);
  numeric_conversion_specifiers_test(out);
  printf_test(out);

  printf("  signbit...\n");
  signbit_test(out);

  printf("  argz...\n");
  argz_test(out);

#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  printf("  _fixpath and realpath...\n");
#else
  printf("  _fixpath...\n");
#endif
  fixpath_and_realpath_test(out);

#if (__DJGPP__  == 2) && (__DJGPP_MINOR__ >= 4)
  printf("  lstat...\n");
#else
  printf("  stat...\n");
#endif
  lstat_and_stat_test(out);
#if 0
  printf("  strlcat and strlcpy...\n");
  strlcat_and_strlcpy_test(out);
#endif
  printf("  memmem...\n");
  memmem_test(out);
  printf("  mb/wc...\n");
  mbtowc_test(out);
  printf("  scanf...\n");
  scanf_test(out);
  printf("  open...\n");
  open_test(out);
  printf("  fopen/freopen/fflush/fseek/ftell/fclose/rewind...\n");
  fopen_freopen_fflush_fseek_ftell_fclose_rewind_test(out);
  fclose(out);

  printf("The test output is in ./tests/test.txt\n");
  return 0;
}
