/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>

#include "../include/libc/unconst.h"
#include "libsupp.h"

#define EOS  '\0'


void
libsupp_argz_extract(const char *argz, size_t argz_len, char **argv)
{
  /*
   *  Store pointers to each string in ARGZ, plus a terminating 0 element,
   *  into the argv array ARGV, which must be large enough to hold them all.
   */

  const size_t counts = libsupp_argz_count(argz, argz_len);
  size_t i;



  if (counts == argz_len)
    for (i = 0; i < counts; i++)
      argv[i] = unconst(&argz[i], char *);
  else if (counts > 1)
  {
    size_t j = counts - 1;

    for (i = argz_len - 2; i; i--)
      if (argz[i] == EOS)
        argv[j--] = unconst(&argz[i + 1], char *);
    argv[0] = unconst(&argz[0], char *);
  }
  argv[counts] = NULL;
}
