/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler.resumable;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.asynchttpclient.handler.resumable.ResumableListener;
import org.asynchttpclient.util.MiscUtils;

public class ResumableRandomAccessFileListener
implements ResumableListener {
    private final RandomAccessFile file;

    public ResumableRandomAccessFileListener(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void onBytesReceived(ByteBuffer buffer) throws IOException {
        this.file.seek(this.file.length());
        if (buffer.hasArray()) {
            this.file.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            byte[] b = new byte[buffer.remaining()];
            int pos = buffer.position();
            buffer.get(b);
            buffer.position(pos);
            this.file.write(b);
        }
    }

    @Override
    public void onAllBytesReceived() {
        MiscUtils.closeSilently(this.file);
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

