/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.Roots;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.RootsAccessor;
import org.netbeans.modules.java.api.common.queries.Bundle;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.SourceGroupRelativeModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class SourcesImpl
implements Sources,
SourceGroupModifierImplementation,
SourceGroupRelativeModifierImplementation,
PropertyChangeListener,
ChangeListener {
    private static final String MODULE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final List<? extends Roots> roots;
    private boolean dirty;
    private final Map<String, SourceGroup[]> cachedGroups = new ConcurrentHashMap<String, SourceGroup[]>();
    private long eventId;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private SourceGroupModifierImplementation sgmi;
    private final FireAction fireTask = new FireAction();

    SourcesImpl(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, Roots ... roots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.roots = Collections.unmodifiableList(Arrays.asList(roots));
        for (Roots roots2 : this.roots) {
            roots2.addPropertyChangeListener(WeakListeners.propertyChange(this, roots2));
        }
        SourcesHelper sh = this.initSources();
        assert (sh != null);
        this.sgmi = sh.createSourceGroupModifierImplementation();
        this.delegate = sh.createSources();
    }

    @Override
    public SourceGroup[] getSourceGroups(final String type) {
        SourceGroup[] _cachedGroups = this.cachedGroups.get(type);
        if (_cachedGroups != null) {
            return _cachedGroups;
        }
        return ProjectManager.mutex().readAccess(new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SourceGroup[] run() {
                FileObject libLoc;
                long myEventId;
                Sources _delegate;
                SourcesImpl sourcesImpl = SourcesImpl.this;
                synchronized (sourcesImpl) {
                    if (SourcesImpl.this.dirty) {
                        SourcesImpl.this.delegate.removeChangeListener(SourcesImpl.this);
                        SourcesHelper sh = SourcesImpl.this.initSources();
                        SourcesImpl.this.sgmi = sh.createSourceGroupModifierImplementation();
                        SourcesImpl.this.delegate = sh.createSources();
                        SourcesImpl.this.delegate.addChangeListener(SourcesImpl.this);
                        SourcesImpl.this.dirty = false;
                    }
                    _delegate = SourcesImpl.this.delegate;
                    myEventId = ++SourcesImpl.this.eventId;
                }
                SourceGroup[] groups = _delegate.getSourceGroups(type);
                if (type.equals("generic") && (libLoc = SourcesImpl.this.getSharedLibraryFolderLocation()) != null) {
                    boolean isIncluded = false;
                    for (SourceGroup sg : groups) {
                        if (!FileUtil.isParentOf(sg.getRootFolder(), libLoc)) continue;
                        isIncluded = true;
                        break;
                    }
                    if (!isIncluded) {
                        SourceGroup[] grps = new SourceGroup[groups.length + 1];
                        System.arraycopy(groups, 0, grps, 0, groups.length);
                        grps[grps.length - 1] = GenericSources.group(SourcesImpl.this.project, libLoc, "sharedlibraries", NbBundle.getMessage(SourcesImpl.class, "LibrarySourceGroup_DisplayName"), null, null);
                        groups = grps;
                    }
                }
                SourcesImpl sourcesImpl2 = SourcesImpl.this;
                synchronized (sourcesImpl2) {
                    if (myEventId == SourcesImpl.this.eventId) {
                        SourcesImpl.this.cachedGroups.put(type, groups);
                    }
                }
                return groups;
            }
        });
    }

    @Override
    public SourceGroupModifierImplementation relativeTo(SourceGroup existingGroup, String ... projectPart) {
        if (this.sgmi instanceof SourceGroupRelativeModifierImplementation) {
            return ((SourceGroupRelativeModifierImplementation)((Object)this.sgmi)).relativeTo(existingGroup, projectPart);
        }
        return this;
    }

    @Override
    public SourceGroup createSourceGroup(String type, String hint) {
        return this.sgmi.createSourceGroup(type, hint);
    }

    @Override
    public boolean canCreateSourceGroup(String type, String hint) {
        return this.sgmi.canCreateSourceGroup(type, hint);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private FileObject getSharedLibraryFolderLocation() {
        File file;
        FileObject libLocFO;
        String libLocEval;
        String libLoc = this.helper.getLibrariesLocation();
        if (libLoc != null && (libLocEval = this.evaluator.evaluate(libLoc)) != null && (libLocFO = FileUtil.toFileObject(file = this.helper.resolveFile(libLocEval))) != null) {
            FileObject libLocParent = libLocFO.getParent();
            return libLocParent;
        }
        return null;
    }

    private SourcesHelper initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        for (Roots roots : this.roots) {
            if (RootsAccessor.getInstance().isSourceRoot(roots)) {
                this.registerSources(sourcesHelper, roots);
                continue;
            }
            this.registerNonSources(sourcesHelper, roots);
        }
        sourcesHelper.registerExternalRoots(0, false);
        return sourcesHelper;
    }

    private void registerSources(SourcesHelper sourcesHelper, Roots roots) {
        String hint = RootsAccessor.getInstance().getHint(roots);
        String type = RootsAccessor.getInstance().getType(roots);
        String includes = RootsAccessor.getInstance().supportIncludes(roots) ? "${includes}" : null;
        String excludes = RootsAccessor.getInstance().supportIncludes(roots) ? "${excludes}" : null;
        String[] rootPathPropNames = RootsAccessor.getInstance().getRootPathProperties(roots);
        String[] propNames = roots.getRootProperties();
        String[] displayNames = roots.getRootDisplayNames();
        for (int i = 0; i < propNames.length; ++i) {
            List<Object> parts;
            List<String> names;
            List<CallSite> locations;
            String prop = propNames[i];
            String pathProp = rootPathPropNames[i];
            if (pathProp == null || "modules".equals(type)) {
                locations = Collections.singletonList("${" + prop + "}");
                names = Collections.singletonList(displayNames[i]);
                parts = Collections.singletonList(null);
            } else {
                File file;
                locations = new ArrayList<CallSite>();
                names = new ArrayList<String>();
                parts = new ArrayList<Object>();
                String pathToModules = this.evaluator.getProperty(prop);
                if (pathToModules != null && (file = this.helper.resolveFile(pathToModules)).isDirectory()) {
                    Collection spVariants = Arrays.stream(PropertyUtils.tokenizePath(this.evaluator.getProperty(pathProp))).map(p -> CommonModuleUtils.parseSourcePathVariants(p)).flatMap(lv -> lv.stream()).collect(Collectors.toList());
                    for (File f : file.listFiles()) {
                        if (!f.isDirectory()) continue;
                        for (String variant : spVariants) {
                            String resolvedSrcPath = String.format("%s/%s/%s", pathToModules, f.getName(), variant);
                            String[] v = variant.split("/");
                            String[] p2 = new String[v.length + 2];
                            p2[0] = f.getName();
                            p2[1] = pathToModules;
                            System.arraycopy(v, 0, p2, 2, v.length);
                            locations.add((CallSite)((Object)resolvedSrcPath));
                            parts.add(p2);
                            String dispName = displayNames[i];
                            if (dispName == null || dispName.isEmpty()) {
                                names.add(Bundle.FMT_ModularSourceRootNoName(f.getName(), pathToModules));
                                continue;
                            }
                            names.add(Bundle.FMT_ModularSourceRootWithName(f.getName(), variant, dispName));
                        }
                    }
                }
            }
            assert (locations.size() == names.size());
            assert (locations.size() == parts.size());
            Iterator<Object> partIt = parts.iterator();
            Iterator<CallSite> locationIt = locations.iterator();
            Iterator<String> nameIt = names.iterator();
            while (locationIt.hasNext() && nameIt.hasNext()) {
                SourcesHelper.SourceRootConfig cfg = sourcesHelper.sourceRoot((String)((Object)locationIt.next()));
                cfg.displayName(nameIt.next());
                if (includes != null) {
                    cfg.includes(includes);
                }
                if (excludes != null) {
                    cfg.excludes(excludes);
                }
                if (hint != null) {
                    cfg.hint(hint);
                }
                cfg.inParts(partIt.next());
                cfg.add();
                if (type == null) continue;
                cfg.type(type).add();
            }
        }
    }

    private void registerNonSources(SourcesHelper sourcesHelper, Roots nonSources) {
        for (String nonSourceRootProp : nonSources.getRootProperties()) {
            sourcesHelper.addNonSourceRoot(String.format("${%s}", nonSourceRootProp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        SourcesImpl sourcesImpl = this;
        synchronized (sourcesImpl) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        ProjectManager.mutex().postReadRequest(this.fireTask.activate());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }

    private class FireAction
    implements Runnable {
        private AtomicBoolean fire = new AtomicBoolean();

        private FireAction() {
        }

        @Override
        public void run() {
            if (this.fire.getAndSet(false)) {
                SourcesImpl.this.changeSupport.fireChange();
            }
        }

        FireAction activate() {
            this.fire.set(true);
            return this;
        }
    }
}

