/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class NbRepository
extends Repository {
    static final String CONFIG_FOLDER = "config";

    public NbRepository() {
        super(NbRepository.createDefaultFileSystem());
    }

    private static FileSystem createDefaultFileSystem() {
        Exception exc;
        ArrayList<File> extradirs;
        File h;
        File u;
        block16: {
            File userDirFile;
            block18: {
                block17: {
                    String ud;
                    String systemDir = System.getProperty("system.dir");
                    if (systemDir != null) {
                        try {
                            return SessionManager.getDefault().create(new File(systemDir), null, new File[0]);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            throw new InternalError();
                        }
                        catch (PropertyVetoException ex) {
                            ex.printStackTrace();
                            throw new InternalError();
                        }
                    }
                    u = null;
                    h = null;
                    extradirs = new ArrayList<File>();
                    String homeDir = CLIOptions.getHomeDir();
                    if (homeDir != null) {
                        File homeDirFile = new File(CLIOptions.getHomeDir());
                        if (!homeDirFile.exists()) {
                            System.err.println(NbBundle.getMessage(NbRepository.class, "CTL_Netbeanshome_notexists"));
                            NbRepository.doExit(2);
                        }
                        if (!homeDirFile.isDirectory()) {
                            System.err.println(NbBundle.getMessage(NbRepository.class, "CTL_Netbeanshome1"));
                            NbRepository.doExit(3);
                        }
                        h = new File(homeDirFile, CONFIG_FOLDER);
                        String nbdirs = System.getProperty("netbeans.dirs");
                        if (nbdirs != null) {
                            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
                            while (tok.hasMoreTokens()) {
                                File f = new File(tok.nextToken(), CONFIG_FOLDER);
                                if (!f.isDirectory()) continue;
                                extradirs.add(f);
                            }
                        }
                    }
                    if ((ud = CLIOptions.getUserDir()).equals("memory")) break block16;
                    userDirFile = new File(ud);
                    if (userDirFile.exists()) break block17;
                    System.err.println(NbBundle.getMessage(NbRepository.class, "CTL_Netbeanshome2"));
                    if (CLIOptions.isFallbackToMemory()) break block16;
                    NbRepository.doExit(4);
                }
                if (userDirFile.isDirectory()) break block18;
                System.err.println(NbBundle.getMessage(NbRepository.class, "CTL_Netbeanshome3"));
                if (CLIOptions.isFallbackToMemory()) break block16;
                NbRepository.doExit(5);
            }
            u = new File(userDirFile, CONFIG_FOLDER);
        }
        try {
            return SessionManager.getDefault().create(u, h, extradirs.toArray(new File[0]));
        }
        catch (IOException ex) {
            exc = ex;
        }
        catch (PropertyVetoException ex) {
            exc = ex;
        }
        catch (RuntimeException ex) {
            exc = ex;
        }
        exc.printStackTrace();
        System.err.println(NbBundle.getMessage(NbRepository.class, "CTL_Cannot_mount_system_fs"));
        NbRepository.doExit(3);
        return null;
    }

    private static void doExit(int value) {
        TopLogging.exit(value);
    }

    public List<URL> additionalLayers(List<URL> urls) {
        for (Repository.LayerProvider p : Lookup.getDefault().lookupAll(Repository.LayerProvider.class)) {
            ArrayList<URL> mix = new ArrayList<URL>(urls);
            mix.addAll(this.findLayers(p));
            urls = mix;
        }
        return urls;
    }

    @Override
    protected void refreshAdditionalLayers() {
        Main.getModuleSystem().getManager().mutex().writeAccess(new Mutex.Action<Void>(){

            @Override
            public Void run() {
                try {
                    ModuleLayeredFileSystem.getInstallationModuleLayer().setURLs(null);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace(ex);
                }
                return null;
            }
        });
    }

    static {
        Main.initializeURLFactory();
    }
}

