/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.mailet.filter.ActionApplier;
import org.apache.james.jmap.mailet.filter.RuleMatcher;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class JMAPFiltering
extends GenericMailet {
    static final ProcessingState RRT_ERROR = new ProcessingState("rrt-error");
    private final Logger logger = LoggerFactory.getLogger(JMAPFiltering.class);
    private final FilteringManagement filteringManagement;
    private final UsersRepository usersRepository;
    private final ActionApplier.Factory actionApplierFactory;

    @Inject
    public JMAPFiltering(FilteringManagement filteringManagement, UsersRepository usersRepository, ActionApplier.Factory actionApplierFactory) {
        this.filteringManagement = filteringManagement;
        this.usersRepository = usersRepository;
        this.actionApplierFactory = actionApplierFactory;
    }

    public void service(Mail mail) {
        mail.getRecipients().forEach(recipient -> this.applyFirstApplicableRule((MailAddress)recipient, mail));
    }

    private void applyFirstApplicableRule(MailAddress recipient, Mail mail) {
        this.retrieveUser(recipient).ifPresent(username -> {
            Rules filteringRules = (Rules)Mono.from((Publisher)this.filteringManagement.listRulesForUser(username)).block();
            RuleMatcher ruleMatcher = new RuleMatcher(filteringRules.getRules());
            Stream<Rule> matchingRules = ruleMatcher.findApplicableRules(mail);
            this.actionApplierFactory.forMail(mail).forRecipient(this.getMailetContext(), recipient, (Username)username).apply(matchingRules.map(Rule::getAction));
        });
    }

    private Optional<Username> retrieveUser(MailAddress recipient) {
        try {
            return Optional.ofNullable(this.usersRepository.getUsername(recipient));
        }
        catch (UsersRepositoryException e) {
            this.logger.error("cannot retrieve user " + recipient.asString(), (Throwable)e);
            return Optional.empty();
        }
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)RRT_ERROR);
    }
}

