/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.servlet.Source;
import org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.webapp.DefaultsDescriptor;
import org.eclipse.jetty.ee10.webapp.Descriptor;
import org.eclipse.jetty.ee10.webapp.FragmentDescriptor;
import org.eclipse.jetty.ee10.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.Origin;
import org.eclipse.jetty.ee10.webapp.OverrideDescriptor;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebDescriptor;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StandardDescriptorProcessor.class);
    public static final String STANDARD_PROCESSOR = "org.eclipse.jetty.standardDescriptorProcessor";
    final Map<String, FilterHolder> _filterHolderMap = new HashMap<String, FilterHolder>();
    final List<FilterHolder> _filterHolders = new ArrayList<FilterHolder>();
    final List<FilterMapping> _filterMappings = new ArrayList<FilterMapping>();
    final Map<String, ServletHolder> _servletHolderMap = new HashMap<String, ServletHolder>();
    final List<ServletHolder> _servletHolders = new ArrayList<ServletHolder>();
    final List<ServletMapping> _servletMappings = new ArrayList<ServletMapping>();

    public StandardDescriptorProcessor() {
        try {
            this.registerVisitor("context-param", this.getClass().getMethod("visitContextParam", __signature));
            this.registerVisitor("display-name", this.getClass().getMethod("visitDisplayName", __signature));
            this.registerVisitor("servlet", this.getClass().getMethod("visitServlet", __signature));
            this.registerVisitor("servlet-mapping", this.getClass().getMethod("visitServletMapping", __signature));
            this.registerVisitor("session-config", this.getClass().getMethod("visitSessionConfig", __signature));
            this.registerVisitor("mime-mapping", this.getClass().getMethod("visitMimeMapping", __signature));
            this.registerVisitor("welcome-file-list", this.getClass().getMethod("visitWelcomeFileList", __signature));
            this.registerVisitor("locale-encoding-mapping-list", this.getClass().getMethod("visitLocaleEncodingList", __signature));
            this.registerVisitor("error-page", this.getClass().getMethod("visitErrorPage", __signature));
            this.registerVisitor("taglib", this.getClass().getMethod("visitTagLib", __signature));
            this.registerVisitor("jsp-config", this.getClass().getMethod("visitJspConfig", __signature));
            this.registerVisitor("security-constraint", this.getClass().getMethod("visitSecurityConstraint", __signature));
            this.registerVisitor("login-config", this.getClass().getMethod("visitLoginConfig", __signature));
            this.registerVisitor("security-role", this.getClass().getMethod("visitSecurityRole", __signature));
            this.registerVisitor("filter", this.getClass().getMethod("visitFilter", __signature));
            this.registerVisitor("filter-mapping", this.getClass().getMethod("visitFilterMapping", __signature));
            this.registerVisitor("listener", this.getClass().getMethod("visitListener", __signature));
            this.registerVisitor("deny-uncovered-http-methods", this.getClass().getMethod("visitDenyUncoveredHttpMethods", __signature));
            this.registerVisitor("default-context-path", this.getClass().getMethod("visitDefaultContextPath", __signature));
            this.registerVisitor("request-character-encoding", this.getClass().getMethod("visitRequestCharacterEncoding", __signature));
            this.registerVisitor("response-character-encoding", this.getClass().getMethod("visitResponseCharacterEncoding", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start(WebAppContext context, Descriptor descriptor) {
        for (FilterHolder filterHolder : context.getServletHandler().getFilters()) {
            this._filterHolderMap.put(filterHolder.getName(), filterHolder);
            this._filterHolders.add(filterHolder);
        }
        if (context.getServletHandler().getFilterMappings() != null) {
            this._filterMappings.addAll(Arrays.asList(context.getServletHandler().getFilterMappings()));
        }
        for (FilterHolder filterHolder : context.getServletHandler().getServlets()) {
            this._servletHolderMap.put(filterHolder.getName(), (ServletHolder)filterHolder);
            this._servletHolders.add((ServletHolder)filterHolder);
        }
        if (context.getServletHandler().getServletMappings() != null) {
            this._servletMappings.addAll(Arrays.asList(context.getServletHandler().getServletMappings()));
        }
    }

    @Override
    public void end(WebAppContext context, Descriptor descriptor) {
        context.getServletHandler().setFilters(this._filterHolders.toArray(new FilterHolder[this._filterHolderMap.size()]));
        context.getServletHandler().setServlets(this._servletHolders.toArray(new ServletHolder[this._servletHolderMap.size()]));
        context.getServletHandler().setFilterMappings(this._filterMappings.toArray(new FilterMapping[this._filterMappings.size()]));
        context.getServletHandler().setServletMappings(this._servletMappings.toArray(new ServletMapping[this._servletMappings.size()]));
        this._filterHolderMap.clear();
        this._filterHolders.clear();
        this._filterMappings.clear();
        this._servletHolderMap.clear();
        this._servletHolders.clear();
        this._servletMappings.clear();
    }

    public void visitContextParam(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        Origin origin = context.getMetaData().getOrigin("context-param." + name);
        switch (origin) {
            case NotSet: {
                context.getInitParams().put(name, value);
                context.getMetaData().setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                context.getInitParams().put(name, value);
                context.getMetaData().setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebFragment: {
                if (!(descriptor instanceof FragmentDescriptor) || ((String)context.getInitParams().get(name)).equals(value)) break;
                throw new IllegalStateException("Conflicting context-param " + name + "=" + value + " in " + descriptor.getURI());
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextParam: {}={}", (Object)name, (Object)value);
        }
    }

    public void visitDisplayName(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof FragmentDescriptor)) {
            context.setDisplayName(node.toString(false, true));
            context.getMetaData().setOrigin("display-name", descriptor);
        }
    }

    public void visitServlet(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node multipart;
        String enabled;
        String async;
        Origin origin;
        String roleName;
        XmlParser.Node startup;
        String jspFile;
        Origin origin2;
        String id = node.getAttribute("id");
        String name = node.getString("servlet-name", false, true);
        ServletHolder holder = this._servletHolderMap.get(name);
        if (holder == null) {
            holder = context.getServletHandler().newServletHolder(new Source(Source.Origin.DESCRIPTOR, descriptor.getResource()));
            holder.setName(name);
            this._servletHolderMap.put(name, holder);
            this._servletHolders.add(holder);
        } else if (Source.Origin.EMBEDDED == holder.getSource().getOrigin() && descriptor instanceof DefaultsDescriptor) {
            return;
        }
        Iterator iParamsIter = node.iterator("init-param");
        block44: while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            String originName = name + ".servlet.init-param." + pname;
            Descriptor originDescriptor = context.getMetaData().getOriginDescriptor(originName);
            origin2 = context.getMetaData().getOrigin(originName);
            switch (origin2) {
                case NotSet: {
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(originName, descriptor);
                    continue block44;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor || descriptor == originDescriptor) continue block44;
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(originName, descriptor);
                    continue block44;
                }
                case WebFragment: {
                    if (descriptor == originDescriptor || holder.getInitParameter(pname).equals(pvalue)) continue block44;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getURI());
                }
            }
            this.unknownOrigin(origin2);
        }
        String servletClass = node.getString("servlet-class", false, true);
        if ("".equals(servletClass)) {
            servletClass = null;
        }
        if (id != null && id.equals("jsp") && servletClass != null) {
            try {
                Loader.loadClass((String)servletClass);
            }
            catch (ClassNotFoundException e) {
                LOG.info("NO JSP Support for {}, did not find {}", (Object)context.getContextPath(), (Object)servletClass);
                servletClass = "org.eclipse.jetty.ee10.servlet.NoJspServlet";
            }
        }
        if (servletClass != null) {
            ((WebDescriptor)descriptor).addClassName(servletClass);
            Origin origin3 = context.getMetaData().getOrigin(name + ".servlet.servlet-class");
            switch (origin3) {
                case NotSet: {
                    holder.setClassName(servletClass);
                    context.getMetaData().setOrigin(name + ".servlet.servlet-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setClassName(servletClass);
                    context.getMetaData().setOrigin(name + ".servlet.servlet-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (servletClass.equals(holder.getClassName())) break;
                    throw new IllegalStateException("Conflicting servlet-class " + servletClass + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin3);
                }
            }
        }
        if ((jspFile = node.getString("jsp-file", false, true)) != null) {
            holder.setForcedPath(jspFile);
        }
        if ((startup = node.get("load-on-startup")) != null) {
            String s = startup.toString(false, true).toLowerCase(Locale.ENGLISH);
            int order = 0;
            if (s.startsWith("t")) {
                LOG.warn("Deprecated boolean load-on-startup.  Please use integer");
                order = 1;
            } else {
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse load-on-startup {}. Please use integer", (Object)s);
                    LOG.trace("IGNORED", (Throwable)e);
                }
            }
            origin2 = context.getMetaData().getOrigin(name + ".servlet.load-on-startup");
            switch (origin2) {
                case NotSet: {
                    holder.setInitOrder(order);
                    context.getMetaData().setOrigin(name + ".servlet.load-on-startup", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setInitOrder(order);
                    context.getMetaData().setOrigin(name + ".servlet.load-on-startup", descriptor);
                    break;
                }
                case WebFragment: {
                    if (order == holder.getInitOrder()) break;
                    throw new IllegalStateException("Conflicting load-on-startup value in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin2);
                }
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        block45: while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("link role {} to {} for {}", new Object[]{roleName, roleLink, this});
                }
                origin = context.getMetaData().getOrigin(name + ".servlet.role-name." + roleName);
                switch (origin) {
                    case NotSet: {
                        holder.setUserRoleLink(roleName, roleLink);
                        context.getMetaData().setOrigin(name + ".servlet.role-name." + roleName, descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) continue block45;
                        holder.setUserRoleLink(roleName, roleLink);
                        context.getMetaData().setOrigin(name + ".servlet.role-name." + roleName, descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (holder.getUserRoleLink(roleName).equals(roleLink)) continue block45;
                        throw new IllegalStateException("Conflicting role-link for role-name " + roleName + " for servlet " + name + " in " + descriptor.getURI());
                    }
                    default: {
                        this.unknownOrigin(origin);
                        break;
                    }
                }
                continue;
            }
            LOG.warn("Ignored invalid security-role-ref element: servlet-name={}, {}", (Object)holder.getName(), (Object)securityRef);
        }
        XmlParser.Node runAs = node.get("run-as");
        if (runAs != null && (roleName = runAs.getString("role-name", false, true)) != null) {
            Origin origin4 = context.getMetaData().getOrigin(name + ".servlet.run-as");
            switch (origin4) {
                case NotSet: {
                    holder.setRunAsRole(roleName);
                    context.getMetaData().setOrigin(name + ".servlet.run-as", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setRunAsRole(roleName);
                    context.getMetaData().setOrigin(name + ".servlet.run-as", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getRunAsRole().equals(roleName)) break;
                    throw new IllegalStateException("Conflicting run-as role " + roleName + " for servlet " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin4);
                }
            }
        }
        if ((async = node.getString("async-supported", false, true)) != null) {
            boolean val = async.length() == 0 || Boolean.parseBoolean(async);
            origin = context.getMetaData().getOrigin(name + ".servlet.async-supported");
            switch (origin) {
                case NotSet: {
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".servlet.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".servlet.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for servlet " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin);
                }
            }
        }
        if ((enabled = node.getString("enabled", false, true)) != null) {
            boolean isEnabled = enabled.length() == 0 || Boolean.parseBoolean(enabled);
            Origin origin5 = context.getMetaData().getOrigin(name + ".servlet.enabled");
            switch (origin5) {
                case NotSet: {
                    holder.setEnabled(isEnabled);
                    context.getMetaData().setOrigin(name + ".servlet.enabled", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setEnabled(isEnabled);
                    context.getMetaData().setOrigin(name + ".servlet.enabled", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isEnabled() == isEnabled) break;
                    throw new IllegalStateException("Conflicting value of servlet enabled for servlet " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin5);
                }
            }
        }
        if ((multipart = node.get("multipart-config")) != null) {
            String location = multipart.getString("location", false, true);
            String maxFile = multipart.getString("max-file-size", false, true);
            String maxRequest = multipart.getString("max-request-size", false, true);
            String threshold = multipart.getString("file-size-threshold", false, true);
            MultipartConfigElement element = new MultipartConfigElement(location, maxFile == null || "".equals(maxFile) ? -1L : Long.parseLong(maxFile), maxRequest == null || "".equals(maxRequest) ? -1L : Long.parseLong(maxRequest), threshold == null || "".equals(threshold) ? 0 : Integer.parseInt(threshold));
            Origin origin6 = context.getMetaData().getOrigin(name + ".servlet.multipart-config");
            switch (origin6) {
                case NotSet: {
                    holder.getRegistration().setMultipartConfig(element);
                    context.getMetaData().setOrigin(name + ".servlet.multipart-config", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.getRegistration().setMultipartConfig(element);
                    context.getMetaData().setOrigin(name + ".servlet.multipart-config", descriptor);
                    break;
                }
                case WebFragment: {
                    MultipartConfigElement cfg = holder.getRegistration().getMultipartConfigElement();
                    if (cfg.getMaxFileSize() != element.getMaxFileSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-file-size for servlet " + name + " in " + descriptor.getURI());
                    }
                    if (cfg.getMaxRequestSize() != element.getMaxRequestSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-request-size for servlet " + name + " in " + descriptor.getURI());
                    }
                    if (cfg.getFileSizeThreshold() != element.getFileSizeThreshold()) {
                        throw new IllegalStateException("Conflicting multipart-config file-size-threshold for servlet " + name + " in " + descriptor.getURI());
                    }
                    if ((cfg.getLocation() == null || element.getLocation() != null && element.getLocation().length() != 0) && (cfg.getLocation() != null || element.getLocation() == null && element.getLocation().length() <= 0)) break;
                    throw new IllegalStateException("Conflicting multipart-config location for servlet " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin6);
                }
            }
        }
    }

    public void visitServletMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String servletName = node.getString("servlet-name", false, true);
        Origin origin = context.getMetaData().getOrigin(servletName + ".servlet.mappings");
        switch (origin) {
            case NotSet: {
                context.getMetaData().setOrigin(servletName + ".servlet.mappings", descriptor);
                this.addServletMapping(servletName, node, context, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                this.addServletMapping(servletName, node, context, descriptor);
                break;
            }
            case WebFragment: {
                this.addServletMapping(servletName, node, context, descriptor);
                break;
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
    }

    public void visitSessionConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node cookieConfig;
        Iterator iter;
        if (context.getSessionHandler() == null) {
            return;
        }
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            long mins = Long.parseLong(tNode.toString(false, true));
            if (TimeUnit.MINUTES.toSeconds(mins) > Integer.MAX_VALUE) {
                throw new IllegalStateException("Max session-timeout in minutes is " + TimeUnit.SECONDS.toMinutes(Integer.MAX_VALUE));
            }
            context.getServletContext().setSessionTimeout((int)mins);
            context.getMetaData().setOrigin("session.timeout", descriptor);
        }
        if ((iter = node.iterator("tracking-mode")).hasNext()) {
            HashSet<Object> modes = null;
            Origin o = context.getMetaData().getOrigin("session.tracking-modes");
            switch (o) {
                case NotSet: 
                case WebDefaults: {
                    modes = new HashSet<SessionTrackingMode>();
                    context.getMetaData().setOrigin("session.tracking-modes", descriptor);
                    break;
                }
                case WebXml: 
                case WebOverride: 
                case WebFragment: {
                    modes = descriptor instanceof OverrideDescriptor ? new HashSet() : new HashSet(context.getSessionHandler().getEffectiveSessionTrackingModes());
                    context.getMetaData().setOrigin("session.tracking-modes", descriptor);
                    break;
                }
                default: {
                    this.unknownOrigin(o);
                }
            }
            while (iter.hasNext()) {
                XmlParser.Node mNode = (XmlParser.Node)iter.next();
                String trackMode = mNode.toString(false, true);
                SessionTrackingMode mode = SessionTrackingMode.valueOf((String)trackMode);
                modes.add(mode);
                context.getMetaData().setOrigin("session.tracking-mode." + String.valueOf(mode), descriptor);
            }
            context.getSessionHandler().setSessionTrackingModes(modes);
        }
        if ((cookieConfig = node.get("cookie-config")) != null) {
            String comment;
            String path;
            String domain;
            String name = cookieConfig.getString("name", false, true);
            if (name != null) {
                this.addSessionConfigAttribute(context, descriptor, "name", name);
            }
            if ((domain = cookieConfig.getString("domain", false, true)) != null) {
                this.addSessionConfigAttribute(context, descriptor, "domain", domain);
            }
            if ((path = cookieConfig.getString("path", false, true)) != null) {
                this.addSessionConfigAttribute(context, descriptor, "path", path);
            }
            if ((comment = cookieConfig.getString("comment", false, true)) != null) {
                this.addSessionConfigAttribute(context, descriptor, "comment", comment);
            }
            if ((tNode = cookieConfig.get("http-only")) != null) {
                this.addSessionConfigAttribute(context, descriptor, "HttpOnly", tNode.toString(false, true));
            }
            if ((tNode = cookieConfig.get("secure")) != null) {
                this.addSessionConfigAttribute(context, descriptor, "secure", tNode.toString(false, true));
            }
            if ((tNode = cookieConfig.get("max-age")) != null) {
                this.addSessionConfigAttribute(context, descriptor, "max-age", tNode.toString(false, true));
            }
            Iterator attributes = cookieConfig.iterator("attribute");
            while (attributes.hasNext()) {
                XmlParser.Node attribute = (XmlParser.Node)attributes.next();
                String aname = attribute.getString("attribute-name", false, true);
                String avalue = attribute.getString("attribute-value", false, true);
                this.addSessionConfigAttribute(context, descriptor, aname, avalue);
            }
        }
    }

    public void addSessionConfigAttribute(WebAppContext context, Descriptor descriptor, String name, String value) {
        if (StringUtil.isBlank((String)name)) {
            return;
        }
        Origin origin = context.getMetaData().getOrigin("cookie-config.attribute." + name);
        switch (origin) {
            case NotSet: {
                context.getSessionHandler().getSessionCookieConfig().setAttribute(name, value);
                context.getMetaData().setOrigin("cookie-config.attribute." + name, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                context.getSessionHandler().getSessionCookieConfig().setAttribute(name, value);
                context.getMetaData().setOrigin("cookie-config.attribute." + name, descriptor);
                break;
            }
            case WebFragment: {
                if (StringUtil.nonNull((String)value).equals(StringUtil.nonNull((String)context.getSessionHandler().getSessionCookieConfig().getAttribute(name)))) break;
                throw new IllegalStateException("Conflicting attribute " + name + "=" + value + " in " + descriptor.getURI());
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
    }

    public void visitMimeMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        if (extension != null) {
            Origin origin = context.getMetaData().getOrigin("extension." + extension);
            switch (origin) {
                case NotSet: {
                    context.getMimeTypes().addMimeMapping(extension, mimeType);
                    context.getMetaData().setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    context.getMimeTypes().addMimeMapping(extension, mimeType);
                    context.getMetaData().setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebFragment: {
                    if (context.getMimeTypes().getMimeByExtension("." + extension).equals(mimeType)) break;
                    throw new IllegalStateException("Conflicting mime-type " + mimeType + " for extension " + extension + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin);
                }
            }
        }
    }

    public void visitWelcomeFileList(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Origin origin = context.getMetaData().getOrigin("welcome-file-list");
        switch (origin) {
            case NotSet: {
                context.getMetaData().setOrigin("welcome-file-list", descriptor);
                this.addWelcomeFiles(context, node, descriptor);
                break;
            }
            case WebXml: {
                this.addWelcomeFiles(context, node, descriptor);
                break;
            }
            case WebDefaults: {
                if (!(descriptor instanceof DefaultsDescriptor || descriptor instanceof OverrideDescriptor || descriptor instanceof FragmentDescriptor)) {
                    context.setWelcomeFiles(new String[0]);
                }
                this.addWelcomeFiles(context, node, descriptor);
                break;
            }
            case WebOverride: {
                this.addWelcomeFiles(context, node, descriptor);
                break;
            }
            case WebFragment: {
                this.addWelcomeFiles(context, node, descriptor);
                break;
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
    }

    public void visitLocaleEncodingList(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        block5: while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            if (encoding == null) continue;
            Origin origin = context.getMetaData().getOrigin("locale-encoding." + locale);
            switch (origin) {
                case NotSet: {
                    context.addLocaleEncoding(locale, encoding);
                    context.getMetaData().setOrigin("locale-encoding." + locale, descriptor);
                    continue block5;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) continue block5;
                    context.addLocaleEncoding(locale, encoding);
                    context.getMetaData().setOrigin("locale-encoding." + locale, descriptor);
                    continue block5;
                }
                case WebFragment: {
                    if (encoding.equals(context.getLocaleEncoding(locale))) continue block5;
                    throw new IllegalStateException("Conflicting locale-encoding mapping for locale " + locale + " in " + descriptor.getURI());
                }
            }
            this.unknownOrigin(origin);
        }
    }

    public void visitErrorPage(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String location;
        String error = node.getString("error-code", false, true);
        int code = 0;
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
            if (error == null || error.length() == 0) {
                error = "org.eclipse.jetty.server.error_page.global";
            }
        } else {
            code = Integer.parseInt(error);
        }
        if (!(location = node.getString("location", false, true)).startsWith("/")) {
            throw new IllegalStateException("Missing leading '/' for location: " + location);
        }
        ErrorPageErrorHandler handler = (ErrorPageErrorHandler)context.getErrorHandler();
        String originName = "error." + error;
        Origin origin = context.getMetaData().getOrigin(originName);
        switch (origin) {
            case NotSet: {
                if (code > 0) {
                    handler.addErrorPage(code, location);
                } else {
                    handler.addErrorPage(error, location);
                }
                context.getMetaData().setOrigin("error." + error, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                Descriptor originDescriptor = context.getMetaData().getOriginDescriptor(originName);
                if (descriptor == originDescriptor) {
                    throw new IllegalStateException("Duplicate error-page " + error + " at " + location);
                }
                if (code > 0) {
                    handler.addErrorPage(code, location);
                } else {
                    handler.addErrorPage(error, location);
                }
                context.getMetaData().setOrigin("error." + error, descriptor);
                break;
            }
            case WebFragment: {
                if (((String)handler.getErrorPages().get(error)).equals(location)) break;
                throw new IllegalStateException("Conflicting error-code or exception-type " + error + " in " + descriptor.getURI());
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
    }

    public void addWelcomeFiles(WebAppContext context, XmlParser.Node node, Descriptor descriptor) {
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            context.getMetaData().setOrigin("welcome-file." + welcome, descriptor);
            if (welcome == null || welcome.trim().length() <= 0) continue;
            context.setWelcomeFiles((String[])ArrayUtil.addToArray((Object[])context.getWelcomeFiles(), (Object)welcome, String.class));
        }
    }

    private boolean resolveAnyDuplicateServletPathMapping(String servletName, String path, WebAppContext context, Descriptor descriptor) {
        Objects.requireNonNull(servletName);
        Objects.requireNonNull(path);
        Objects.requireNonNull(context);
        Objects.requireNonNull(descriptor);
        ServletMapping existing = null;
        block0: for (ServletMapping existingMapping : this._servletMappings) {
            for (String pathSpec : existingMapping.getPathSpecs()) {
                if (!Objects.equals(pathSpec, path)) continue;
                existing = existingMapping;
                break block0;
            }
        }
        if (existing == null) {
            return true;
        }
        if (Objects.equals(existing.getServletName(), servletName)) {
            return false;
        }
        if (existing.getSource().getOrigin() == Source.Origin.EMBEDDED && descriptor instanceof DefaultsDescriptor) {
            return false;
        }
        if (existing.getSource().getOrigin() == Source.Origin.DESCRIPTOR && existing.getSource().getResource().equals(descriptor.getResource())) {
            throw new IllegalStateException("Duplicate mappings for " + path);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed path {} from mapping {}", (Object)path, (Object)existing);
        }
        existing.setPathSpecs((String[])ArrayUtil.removeFromArray((Object[])existing.getPathSpecs(), (Object)path));
        if (existing.getPathSpecs() == null || existing.getPathSpecs().length == 0) {
            this._servletMappings.remove(existing);
        }
        return true;
    }

    public ServletMapping addServletMapping(String servletName, XmlParser.Node node, WebAppContext context, Descriptor descriptor) {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String path = ((XmlParser.Node)iter.next()).toString(false, true);
            if (!this.resolveAnyDuplicateServletPathMapping(servletName, path = ServletPathSpec.normalize((String)path), context, descriptor)) continue;
            paths.add(path);
            context.getMetaData().setOrigin(servletName + ".servlet.mapping.url" + path, descriptor);
        }
        if (paths.isEmpty()) {
            return null;
        }
        ServletMapping mapping = new ServletMapping(new Source(Source.Origin.DESCRIPTOR, descriptor.getResource()));
        mapping.setServletName(servletName);
        mapping.setFromDefaultDescriptor(descriptor instanceof DefaultsDescriptor);
        context.getMetaData().setOrigin(servletName + ".servlet.mapping." + Long.toHexString(mapping.hashCode()), descriptor);
        mapping.setPathSpecs(paths.toArray(new String[0]));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added mapping {} ", (Object)mapping);
        }
        this._servletMappings.add(mapping);
        return mapping;
    }

    public void addFilterMapping(String filterName, XmlParser.Node node, WebAppContext context, Descriptor descriptor) {
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filterName);
        context.getMetaData().setOrigin(filterName + ".filter.mapping." + Long.toHexString(mapping.hashCode()), descriptor);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = ServletPathSpec.normalize((String)p);
            paths.add(p);
            context.getMetaData().setOrigin(filterName + ".filter.mapping.url" + p, descriptor);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            context.getMetaData().setOrigin(filterName + ".filter.mapping.servlet" + n, descriptor);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        ArrayList<DispatcherType> dispatches = new ArrayList<DispatcherType>();
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatches.add(FilterMapping.dispatch((String)d));
        }
        if (dispatches.size() > 0) {
            mapping.setDispatcherTypes(EnumSet.copyOf(dispatches));
        }
        this._filterMappings.add(mapping);
    }

    public void visitTagLib(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        context.setResourceAlias(uri, location);
        ServletContextHandler.JspConfig config = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor();
        if (config == null) {
            config = new ServletContextHandler.JspConfig();
            context.getContext().getServletContext().setJspConfigDescriptor((JspConfigDescriptor)config);
        }
        ServletContextHandler.TagLib tl = new ServletContextHandler.TagLib();
        tl.setTaglibLocation(location);
        tl.setTaglibURI(uri);
        config.addTaglibDescriptor((TaglibDescriptor)tl);
    }

    public void visitJspConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        ServletContextHandler.JspConfig config = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor();
        if (config == null) {
            config = new ServletContextHandler.JspConfig();
            context.getContext().getServletContext().setJspConfigDescriptor((JspConfigDescriptor)config);
        }
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.visitTagLib(context, descriptor, (XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        ArrayList<String> paths = new ArrayList<String>();
        while (iter.hasNext()) {
            ServletContextHandler.JspPropertyGroup jpg = new ServletContextHandler.JspPropertyGroup();
            config.addJspPropertyGroup((JspPropertyGroupDescriptor)jpg);
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = ServletPathSpec.normalize((String)url);
                paths.add(url);
                jpg.addUrlPattern(url);
            }
            jpg.setErrorOnELNotFound(group.getString("error-on-el-not-found", false, true));
            jpg.setElIgnored(group.getString("el-ignored", false, true));
            jpg.setPageEncoding(group.getString("page-encoding", false, true));
            jpg.setScriptingInvalid(group.getString("scripting-invalid", false, true));
            jpg.setIsXml(group.getString("is-xml", false, true));
            jpg.setDeferredSyntaxAllowedAsLiteral(group.getString("deferred-syntax-allowed-as-literal", false, true));
            jpg.setTrimDirectiveWhitespaces(group.getString("trim-directive-whitespaces", false, true));
            jpg.setDefaultContentType(group.getString("default-content-type", false, true));
            jpg.setBuffer(group.getString("buffer", false, true));
            jpg.setErrorOnUndeclaredNamespace(group.getString("error-on-undeclared-namespace", false, true));
            Iterator preludes = group.iterator("include-prelude");
            while (preludes.hasNext()) {
                String prelude = ((XmlParser.Node)preludes.next()).toString(false, true);
                jpg.addIncludePrelude(prelude);
            }
            Iterator codas = group.iterator("include-coda");
            while (codas.hasNext()) {
                String coda = ((XmlParser.Node)codas.next()).toString(false, true);
                jpg.addIncludeCoda(coda);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(config.toString());
        }
        if (paths.size() > 0) {
            ServletMapping jspMapping = null;
            for (ServletMapping m : this._servletMappings) {
                if (!m.getServletName().equals("jsp")) continue;
                jspMapping = m;
                break;
            }
            if (jspMapping != null) {
                if (jspMapping.getPathSpecs() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding all paths from jsp-config to jsp servlet mapping");
                    }
                    jspMapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                } else {
                    ListIterator piterator = paths.listIterator();
                    while (piterator.hasNext()) {
                        String p = (String)piterator.next();
                        if (!jspMapping.containsPathSpec(p)) continue;
                        piterator.remove();
                    }
                    if (paths.size() > 0) {
                        for (String p : jspMapping.getPathSpecs()) {
                            paths.add(p);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding extra paths from jsp-config to jsp servlet mapping");
                        }
                        jspMapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                    }
                }
            } else {
                ServletMapping mapping = new ServletMapping(new Source(Source.Origin.DESCRIPTOR, descriptor.getResource()));
                mapping.setServletName("jsp");
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                this._servletMappings.add(mapping);
            }
        }
    }

    public void visitSecurityConstraint(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node data;
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (!(securityHandler instanceof ConstraintAware)) {
            LOG.warn("security-constraint declared but SecurityHandler not ConstraintAware");
            return;
        }
        ConstraintAware constraintAware = (ConstraintAware)securityHandler;
        Constraint.Builder scBase = new Constraint.Builder(Constraint.ALLOWED_ANY_TRANSPORT);
        XmlParser.Node auths = node.get("auth-constraint");
        if (auths != null) {
            Iterator iter = auths.iterator("role-name");
            ArrayList<String> roles = new ArrayList<String>();
            block17: while (iter.hasNext()) {
                String role = ((XmlParser.Node)iter.next()).toString(false, true);
                if (StringUtil.isBlank((String)role)) continue;
                switch (role) {
                    case "*": {
                        if (scBase.getAuthorization() == Constraint.Authorization.ANY_USER) continue block17;
                        scBase.authorization(Constraint.Authorization.KNOWN_ROLE);
                        roles = null;
                        continue block17;
                    }
                    case "**": {
                        scBase.authorization(Constraint.Authorization.ANY_USER);
                        roles = null;
                        continue block17;
                    }
                }
                if (roles == null) continue;
                roles.add(role);
            }
            if (roles != null) {
                if (roles.isEmpty()) {
                    scBase.authorization(Constraint.Authorization.FORBIDDEN);
                } else {
                    scBase.authorization(Constraint.Authorization.SPECIFIC_ROLE);
                    scBase.roles(roles.toArray(new String[0]));
                }
            }
        }
        if ((data = node.get("user-data-constraint")) != null) {
            String guarantee;
            data = data.get("transport-guarantee");
            scBase.transport(switch (guarantee = data.toString(false, true).toUpperCase(Locale.ENGLISH)) {
                case "INTEGRAL", "CONFIDENTIAL" -> Constraint.Transport.SECURE;
                case "NONE" -> Constraint.Transport.ANY;
                default -> {
                    LOG.warn("Unknown user-data-constraint: {}", (Object)guarantee);
                    yield null;
                }
            });
        }
        Iterator iter = node.iterator("web-resource-collection");
        while (iter.hasNext()) {
            XmlParser.Node collection = (XmlParser.Node)iter.next();
            scBase.name(collection.getString("web-resource-name", false, true));
            Constraint sc = scBase.build();
            Iterator iter2 = collection.iterator("url-pattern");
            while (iter2.hasNext()) {
                ConstraintMapping mapping;
                String method;
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = ServletPathSpec.normalize((String)url);
                context.getMetaData().setOrigin("constraint.url." + url, descriptor);
                Iterator methods = collection.iterator("http-method");
                Iterator ommissions = collection.iterator("http-method-omission");
                if (methods.hasNext()) {
                    if (ommissions.hasNext()) {
                        throw new IllegalStateException("web-resource-collection cannot contain both http-method and http-method-omission");
                    }
                    while (methods.hasNext()) {
                        method = ((XmlParser.Node)methods.next()).toString(false, true);
                        mapping = new ConstraintMapping();
                        mapping.setMethod(method);
                        mapping.setPathSpec(url);
                        mapping.setConstraint(sc);
                        constraintAware.addConstraintMapping(mapping);
                    }
                    continue;
                }
                if (ommissions.hasNext()) {
                    while (ommissions.hasNext()) {
                        method = ((XmlParser.Node)ommissions.next()).toString(false, true);
                        mapping = new ConstraintMapping();
                        mapping.setMethodOmissions(new String[]{method});
                        mapping.setPathSpec(url);
                        mapping.setConstraint(sc);
                        constraintAware.addConstraintMapping(mapping);
                    }
                    continue;
                }
                ConstraintMapping mapping2 = new ConstraintMapping();
                mapping2.setPathSpec(url);
                mapping2.setConstraint(sc);
                constraintAware.addConstraintMapping(mapping2);
            }
        }
    }

    public void visitLoginConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        block24: {
            block25: {
                XmlParser.Node method = node.get("auth-method");
                if (method == null) break block24;
                Origin origin = context.getMetaData().getOrigin("auth-method");
                switch (origin) {
                    case NotSet: {
                        context.getSecurityHandler().setAuthenticationType(method.toString(false, true));
                        context.getMetaData().setOrigin("auth-method", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSecurityHandler().setAuthenticationType(method.toString(false, true));
                        context.getMetaData().setOrigin("auth-method", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSecurityHandler().getAuthenticationType().equals(method.toString(false, true))) break;
                        throw new IllegalStateException("Conflicting auth-method value in " + descriptor.getURI());
                    }
                    default: {
                        this.unknownOrigin(origin);
                    }
                }
                XmlParser.Node name = node.get("realm-name");
                String nameStr = name == null ? "default" : name.toString(false, true);
                Origin originRealmName = context.getMetaData().getOrigin("realm-name");
                switch (originRealmName) {
                    case NotSet: {
                        context.getSecurityHandler().setRealmName(nameStr);
                        context.getMetaData().setOrigin("realm-name", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSecurityHandler().setRealmName(nameStr);
                        context.getMetaData().setOrigin("realm-name", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSecurityHandler().getRealmName().equals(nameStr)) break;
                        throw new IllegalStateException("Conflicting realm-name value in " + descriptor.getURI());
                    }
                    default: {
                        this.unknownOrigin(originRealmName);
                    }
                }
                if (!"FORM".equalsIgnoreCase(context.getSecurityHandler().getAuthenticationType())) break block24;
                XmlParser.Node formConfig = node.get("form-login-config");
                if (formConfig == null) break block25;
                String loginPageName = null;
                XmlParser.Node loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    loginPageName = loginPage.toString(false, true);
                }
                String errorPageName = null;
                XmlParser.Node errorPage = formConfig.get("form-error-page");
                if (errorPage != null) {
                    errorPageName = errorPage.toString(false, true);
                }
                Origin originFormLoginPage = context.getMetaData().getOrigin("form-login-page");
                switch (originFormLoginPage) {
                    case NotSet: {
                        context.getSecurityHandler().setParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                        context.getMetaData().setOrigin("form-login-page", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof FragmentDescriptor) break;
                        context.getSecurityHandler().setParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                        context.getMetaData().setOrigin("form-login-page", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (context.getSecurityHandler().getParameter("org.eclipse.jetty.security.form_login_page").equals(loginPageName)) break;
                        throw new IllegalStateException("Conflicting form-login-page value in " + descriptor.getURI());
                    }
                    default: {
                        this.unknownOrigin(originFormLoginPage);
                    }
                }
                Origin originFormErrorPage = context.getMetaData().getOrigin("form-error-page");
                switch (originFormErrorPage) {
                    case NotSet: {
                        context.getSecurityHandler().setParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                        context.getMetaData().setOrigin("form-error-page", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (!(descriptor instanceof FragmentDescriptor)) {
                            context.getSecurityHandler().setParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                            context.getMetaData().setOrigin("form-error-page", descriptor);
                            break;
                        }
                        break block24;
                    }
                    case WebFragment: {
                        if (!context.getSecurityHandler().getParameter("org.eclipse.jetty.security.form_error_page").equals(errorPageName)) {
                            throw new IllegalStateException("Conflicting form-error-page value in " + descriptor.getURI());
                        }
                        break block24;
                    }
                    default: {
                        this.unknownOrigin(originFormErrorPage);
                        break;
                    }
                }
                break block24;
            }
            throw new IllegalStateException("!form-login-config");
        }
    }

    public void visitSecurityRole(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (context.getSecurityHandler() == null) {
            LOG.warn("security-role declared but SecurityHandler==null");
            return;
        }
        XmlParser.Node roleNode = node.get("role-name");
        String role = roleNode.toString(false, true);
        ((ConstraintAware)context.getSecurityHandler()).addKnownRole(role);
        context.getMetaData().setOrigin("security-role." + role, descriptor);
    }

    public void visitFilter(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String filterClass;
        String name = node.getString("filter-name", false, true);
        FilterHolder holder = this._filterHolderMap.get(name);
        if (holder == null) {
            holder = context.getServletHandler().newFilterHolder(new Source(Source.Origin.DESCRIPTOR, descriptor.getResource()));
            holder.setName(name);
            this._filterHolderMap.put(name, holder);
            this._filterHolders.add(holder);
        }
        if ((filterClass = node.getString("filter-class", false, true)) != null) {
            ((WebDescriptor)descriptor).addClassName(filterClass);
            Origin origin = context.getMetaData().getOrigin(name + ".filter.filter-class");
            switch (origin) {
                case NotSet: {
                    holder.setClassName(filterClass);
                    context.getMetaData().setOrigin(name + ".filter.filter-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setClassName(filterClass);
                    context.getMetaData().setOrigin(name + ".filter.filter-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getClassName().equals(filterClass)) break;
                    throw new IllegalStateException("Conflicting filter-class for filter " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin);
                }
            }
        }
        Iterator iter = node.iterator("init-param");
        block15: while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            Origin origin = context.getMetaData().getOrigin(name + ".filter.init-param." + pname);
            switch (origin) {
                case NotSet: {
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(name + ".filter.init-param." + pname, descriptor);
                    continue block15;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) continue block15;
                    holder.setInitParameter(pname, pvalue);
                    context.getMetaData().setOrigin(name + ".filter.init-param." + pname, descriptor);
                    continue block15;
                }
                case WebFragment: {
                    if (holder.getInitParameter(pname).equals(pvalue)) continue block15;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getURI());
                }
            }
            this.unknownOrigin(origin);
        }
        String async = node.getString("async-supported", false, true);
        if (async != null) {
            holder.setAsyncSupported(async.length() == 0 || Boolean.parseBoolean(async));
        }
        if (async != null) {
            boolean val = async.length() == 0 || Boolean.parseBoolean(async);
            Origin origin = context.getMetaData().getOrigin(name + ".filter.async-supported");
            switch (origin) {
                case NotSet: {
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".filter.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof FragmentDescriptor) break;
                    holder.setAsyncSupported(val);
                    context.getMetaData().setOrigin(name + ".filter.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for filter " + name + " in " + descriptor.getURI());
                }
                default: {
                    this.unknownOrigin(origin);
                }
            }
        }
    }

    public void visitFilterMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String filterName = node.getString("filter-name", false, true);
        Origin origin = context.getMetaData().getOrigin(filterName + ".filter.mappings");
        switch (origin) {
            case NotSet: {
                context.getMetaData().setOrigin(filterName + ".filter.mappings", descriptor);
                this.addFilterMapping(filterName, node, context, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof FragmentDescriptor) break;
                this.addFilterMapping(filterName, node, context, descriptor);
                break;
            }
            case WebFragment: {
                this.addFilterMapping(filterName, node, context, descriptor);
                break;
            }
            default: {
                this.unknownOrigin(origin);
            }
        }
    }

    public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        try {
            if (className != null && className.length() > 0) {
                for (ListenerHolder holder : context.getServletHandler().getListeners()) {
                    if (!holder.getClassName().equals(className)) continue;
                    return;
                }
                ((WebDescriptor)descriptor).addClassName(className);
                ListenerHolder h = context.getServletHandler().newListenerHolder(new Source(Source.Origin.DESCRIPTOR, descriptor.getResource()));
                h.setClassName(className);
                context.getServletHandler().addListener(h);
                context.getMetaData().setOrigin(className + ".listener", descriptor);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not instantiate listener {}", (Object)className, (Object)e);
        }
    }

    public void visitDenyUncoveredHttpMethods(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (context.getSecurityHandler() == null) {
            LOG.warn("deny-uncovered-http-methods declared but SecurityHandler==null");
            return;
        }
        ((ConstraintAware)context.getSecurityHandler()).setDenyUncoveredHttpMethods(true);
    }

    public void visitDefaultContextPath(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof FragmentDescriptor)) {
            String path = node.toString(false, true);
            context.setAttribute("default-context-path", path);
            if (context.isContextPathDefault()) {
                context.setDefaultContextPath(path);
                context.getMetaData().setOrigin("default-context-path", descriptor);
            }
        }
    }

    public void visitRequestCharacterEncoding(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof FragmentDescriptor)) {
            String encoding = node.toString(false, true);
            context.setAttribute("request-character-encoding", encoding);
            context.setDefaultRequestCharacterEncoding(encoding);
            context.getMetaData().setOrigin("request-character-encoding", descriptor);
        }
    }

    public void visitResponseCharacterEncoding(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof FragmentDescriptor)) {
            String encoding = node.toString(false, true);
            context.setAttribute("response-character-encoding", encoding);
            context.setDefaultResponseCharacterEncoding(encoding);
            context.getMetaData().setOrigin("response-character-encoding", descriptor);
        }
    }

    private void unknownOrigin(Origin origin) {
        LOG.warn("Unknown descriptor origin {}", (Object)origin, (Object)new Throwable());
    }
}

