/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class CrtResponseFileResponseTransformer<ResponseT>
implements AsyncResponseTransformer<ResponseT, ResponseT> {
    private static final Logger log = Logger.loggerFor(CrtResponseFileResponseTransformer.class);
    private volatile CompletableFuture<Void> cf;
    private volatile ResponseT response;

    public CompletableFuture<ResponseT> prepare() {
        this.cf = new CompletableFuture();
        return this.cf.thenApply(ignored -> this.response);
    }

    public void onResponse(ResponseT response) {
        this.response = response;
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)new OnCompleteSubscriber(this.cf, this::exceptionOccurred));
    }

    public void exceptionOccurred(Throwable throwable) {
        if (this.cf != null) {
            this.cf.completeExceptionally(throwable);
        } else {
            log.warn(() -> "An exception occurred before the call to prepare() was able to instantiate the CompletableFuture. The future cannot be completed exceptionally because it is null");
        }
    }

    private static final class OnCompleteSubscriber
    implements Subscriber<ByteBuffer> {
        private final CompletableFuture<Void> future;
        private final Consumer<Throwable> onErrorMethod;
        private Subscription subscription;

        private OnCompleteSubscriber(CompletableFuture<Void> future, Consumer<Throwable> onErrorMethod) {
            this.future = future;
            this.onErrorMethod = onErrorMethod;
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
        }

        public void onNext(ByteBuffer byteBuffer) {
            this.onErrorMethod.accept(new IllegalStateException("OnCompleteSubscriber received unexpected call to onNext."));
        }

        public void onError(Throwable throwable) {
            this.onErrorMethod.accept(throwable);
        }

        public void onComplete() {
            this.future.complete(null);
        }
    }
}

