/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.postgres;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.sieve.postgres.PostgresSieveDataDefinition;
import org.apache.james.sieve.postgres.model.PostgresSieveScript;
import org.apache.james.sieve.postgres.model.PostgresSieveScriptId;
import org.apache.james.sieverepository.api.ScriptName;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresSieveScriptDAO {
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresSieveScriptDAO(@Named(value="default") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Integer> upsertScript(PostgresSieveScript sieveScript) {
        return this.postgresExecutor.executeReturnAffectedRowsCount(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_ID, (Object)sieveScript.getId().getValue()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME, (Object)sieveScript.getUsername()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME, (Object)sieveScript.getScriptName()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_SIZE, (Object)sieveScript.getScriptSize()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_CONTENT, (Object)sieveScript.getScriptContent()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE, (Object)sieveScript.isActive()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.ACTIVATION_DATE_TIME, (Object)sieveScript.getActivationDateTime()).onConflict(new Field[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME, PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME}).doUpdate().set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_SIZE, (Object)sieveScript.getScriptSize()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_CONTENT, (Object)sieveScript.getScriptContent()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE, (Object)sieveScript.isActive()).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.ACTIVATION_DATE_TIME, (Object)sieveScript.getActivationDateTime())));
    }

    public Mono<PostgresSieveScript> getScript(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.selectFrom(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())}))).map(this.recordToPostgresSieveScript());
    }

    public Mono<Long> getScriptSize(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_SIZE).from(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())}))).map(record -> (Long)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_SIZE));
    }

    public Mono<Boolean> getIsActive(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE).from(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())}))).map(record -> (Boolean)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE));
    }

    public Mono<Boolean> scriptExists(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeExists(dslContext -> dslContext.selectOne().from(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())}));
    }

    public Flux<PostgresSieveScript> getScripts(Username username) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString())))).map(this.recordToPostgresSieveScript());
    }

    public Mono<PostgresSieveScript> getActiveScript(Username username) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.selectFrom(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE.eq((Object)true)}))).map(this.recordToPostgresSieveScript());
    }

    public Mono<Void> activateScript(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.update(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE, (Object)true).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.ACTIVATION_DATE_TIME, (Object)OffsetDateTime.now()).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())})));
    }

    public Mono<Void> deactivateCurrentActiveScript(Username username) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.update(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE, (Object)false).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE.eq((Object)true)})));
    }

    public Mono<Integer> renameScript(Username username, ScriptName oldName, ScriptName newName) {
        return this.postgresExecutor.executeReturnAffectedRowsCount(dslContext -> Mono.from((Publisher)dslContext.update(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).set(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME, (Object)newName.getValue()).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)oldName.getValue())})));
    }

    public Mono<Void> deleteScript(Username username, ScriptName scriptName) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresSieveDataDefinition.PostgresSieveScriptTable.TABLE_NAME).where(new Condition[]{PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME.eq((Object)username.asString()), PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME.eq((Object)scriptName.getValue())})));
    }

    private Function<Record, PostgresSieveScript> recordToPostgresSieveScript() {
        return record -> PostgresSieveScript.builder().username((String)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.USERNAME)).scriptName((String)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_NAME)).scriptContent((String)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_CONTENT)).scriptSize((Long)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_SIZE)).isActive((Boolean)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.IS_ACTIVE)).activationDateTime((OffsetDateTime)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.ACTIVATION_DATE_TIME)).id(new PostgresSieveScriptId((UUID)record.get(PostgresSieveDataDefinition.PostgresSieveScriptTable.SCRIPT_ID))).build();
    }
}

