/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class MailboxMergingRequest {
    private final String mergeOrigin;
    private final String mergeDestination;

    @JsonCreator
    public MailboxMergingRequest(@JsonProperty(value="mergeOrigin") String mergeOrigin, @JsonProperty(value="mergeDestination") String mergeDestination) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mergeOrigin) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mergeDestination) ? 1 : 0) != 0);
        this.mergeOrigin = mergeOrigin;
        this.mergeDestination = mergeDestination;
    }

    public String getMergeOrigin() {
        return this.mergeOrigin;
    }

    public String getMergeDestination() {
        return this.mergeDestination;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxMergingRequest) {
            MailboxMergingRequest that = (MailboxMergingRequest)o;
            return Objects.equals(this.mergeOrigin, that.mergeOrigin) && Objects.equals(this.mergeDestination, that.mergeDestination);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mergeOrigin, this.mergeDestination);
    }
}

