/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

abstract class MathSubscriber<T, R>
extends Operators.MonoSubscriber<T, R> {
    Subscription s;
    boolean done;

    MathSubscriber(CoreSubscriber<? super R> actual) {
        super(actual);
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        if (this.done) {
            Operators.onNextDropped(t, (Context)this.actual.currentContext());
            return;
        }
        try {
            this.updateResult(t);
        }
        catch (Throwable ex) {
            this.reset();
            this.done = true;
            this.actual.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)ex, t, (Context)this.actual.currentContext()));
            return;
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
            return;
        }
        this.done = true;
        this.reset();
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        R r = this.result();
        if (r != null) {
            this.complete(r);
        } else {
            this.actual.onComplete();
        }
    }

    public void cancel() {
        super.cancel();
        this.s.cancel();
    }

    protected abstract void reset();

    protected abstract R result();

    protected abstract void updateResult(T var1);
}

