/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import org.eclipse.yasson.internal.serializer.MapSerializer;

public class MapToObjectSerializer<K, V>
implements MapSerializer.Delegate<K, V> {
    private final MapSerializer<K, V> serializer;

    protected MapToObjectSerializer(MapSerializer<K, V> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    public void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }

    @Override
    public void serializeContainer(Map<K, V> obj, JsonGenerator generator, SerializationContext ctx) {
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            K key = entry.getKey();
            String keyString = key instanceof Enum ? ((Enum)key).name() : String.valueOf(key);
            V value = entry.getValue();
            if (value == null) {
                if (!this.serializer.isNullable()) continue;
                generator.writeNull(keyString);
                continue;
            }
            generator.writeKey(keyString);
            this.serializer.serializeItem(value, generator, ctx);
        }
    }
}

