/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractItem;
import org.eclipse.yasson.internal.serializer.ContainerDeserializerUtils;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

public class MapEntriesArrayDeserializer<K, V>
extends AbstractItem<Map<K, V>>
implements JsonbDeserializer<Map<K, V>> {
    private static final String DEFAULT_KEY_ENTRY_NAME = "key";
    private static final String DEFAULT_VALUE_ENTRY_NAME = "value";
    private final Map<K, V> instance;
    private final Type mapKeyType;
    private final Type mapValueType;
    private State state;
    private K key;
    private V value;
    private final String keyEntryName;
    private final String valueEntryName;

    MapEntriesArrayDeserializer(DeserializerBuilder builder) {
        super(builder);
        Type mapType = this.getRuntimeType();
        this.mapKeyType = ContainerDeserializerUtils.mapKeyType(this, mapType);
        this.mapValueType = ContainerDeserializerUtils.mapValueType(this, mapType);
        this.instance = ContainerDeserializerUtils.createMapInstance(builder, mapType);
        this.state = State.NEXT_ENTRY;
        this.keyEntryName = DEFAULT_KEY_ENTRY_NAME;
        this.valueEntryName = DEFAULT_VALUE_ENTRY_NAME;
    }

    public Map<K, V> deserialize(JsonParser parser, DeserializationContext context, Type rtType) {
        Context ctx = new Context(parser, (Unmarshaller)context);
        ((JsonbParser)ctx.parser).moveTo(JsonParser.Event.START_ARRAY);
        block9: while (parser.hasNext() && ctx.parse()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_ARRAY: {
                    this.startArray(ctx, event);
                    continue block9;
                }
                case START_OBJECT: {
                    this.startObject(ctx, event);
                    continue block9;
                }
                case KEY_NAME: {
                    this.keyName(ctx, event);
                    continue block9;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    this.simpleValue(ctx, event);
                    continue block9;
                }
                case VALUE_NULL: {
                    this.valueNull(ctx, event);
                    continue block9;
                }
                case END_ARRAY: {
                    this.endArray(ctx, event);
                    continue block9;
                }
                case END_OBJECT: {
                    this.endObject(ctx, event);
                    continue block9;
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.NOT_VALUE_TYPE, event));
        }
        return this.instance;
    }

    public void startArray(Context ctx, JsonParser.Event event) {
        switch (this.state) {
            case ENTRY_KEY_OBJECT: {
                this.key = this.deserializeContent(ctx, this.mapKeyType, event);
                break;
            }
            case ENTRY_VALUE_OBJECT: {
                this.value = this.deserializeContent(ctx, this.mapValueType, event);
                break;
            }
            default: {
                MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
            }
        }
        this.state = State.ENTRY_KEY;
    }

    private void startObject(Context ctx, JsonParser.Event event) {
        switch (this.state) {
            case NEXT_ENTRY: {
                this.clearMapEntry();
                break;
            }
            case ENTRY_KEY_OBJECT: {
                this.key = this.deserializeContent(ctx, this.mapKeyType, event);
                break;
            }
            case ENTRY_VALUE_OBJECT: {
                this.value = this.deserializeContent(ctx, this.mapValueType, event);
                break;
            }
            default: {
                MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
            }
        }
        this.state = State.ENTRY_KEY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void keyName(Context ctx, JsonParser.Event event) {
        if (this.state == State.ENTRY_KEY) {
            String key = ctx.getParser().getString();
            if (this.keyEntryName.equals(key)) {
                this.state = State.ENTRY_KEY_OBJECT;
                return;
            } else {
                if (!this.valueEntryName.equals(key)) throw new JsonbException("Invalid Map entry key: " + key);
                this.state = State.ENTRY_VALUE_OBJECT;
            }
            return;
        } else {
            MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
        }
    }

    private void simpleValue(Context ctx, JsonParser.Event event) {
        switch (this.state) {
            case ENTRY_KEY_OBJECT: {
                this.key = this.deserializeContent(ctx, this.mapKeyType, event);
                break;
            }
            case ENTRY_VALUE_OBJECT: {
                this.value = this.deserializeContent(ctx, this.mapValueType, event);
                break;
            }
            default: {
                MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
            }
        }
        this.state = State.ENTRY_KEY;
    }

    private void valueNull(Context ctx, JsonParser.Event event) {
        switch (this.state) {
            case ENTRY_KEY_OBJECT: 
            case ENTRY_VALUE_OBJECT: {
                break;
            }
            default: {
                MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
            }
        }
        this.state = State.ENTRY_KEY;
    }

    private void endArray(Context ctx, JsonParser.Event event) {
        if (this.state == State.NEXT_ENTRY) {
            ctx.finish();
        } else {
            MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
        }
        this.state = State.ARRAY_END;
    }

    private void endObject(Context ctx, JsonParser.Event event) {
        if (this.state == State.ENTRY_KEY) {
            this.instance.put(this.key, this.value);
        } else {
            MapEntriesArrayDeserializer.handleSyntaxError(this.state, event);
        }
        this.state = State.NEXT_ENTRY;
    }

    private static void handleSyntaxError(State state, JsonParser.Event event) {
        switch (state) {
            case NEXT_ENTRY: {
                throw new JsonbException("Map deserialization error: got " + event.name() + " when expecting beginning of map entry JSON object or end of whole map entries array");
            }
            case ENTRY_KEY: {
                throw new JsonbException("Map deserialization error: got " + event.name() + " when expecting map entry attribute name 'key' or 'value' or end of map entry JSON object");
            }
            case ENTRY_KEY_OBJECT: {
                throw new JsonbException("Map deserialization error: got " + event.name() + " when expecting map entry attribute value related to target map entry key");
            }
            case ENTRY_VALUE_OBJECT: {
                throw new JsonbException("Map deserialization error: got " + event.name() + " when expecting map entry attribute value related to target map entry value");
            }
            case ARRAY_END: {
                throw new JsonbException("Map deserialization error: got " + event.name() + " when current map deserialization was already finished");
            }
        }
        throw new IllegalStateException("Unknown map deserialization parser state: " + state.name());
    }

    private <T> T deserializeContent(Context ctx, Type contentType, JsonParser.Event event) {
        JsonbDeserializer<?> deserializer = ContainerDeserializerUtils.newCollectionOrMapItem(this, contentType, ctx.getUnmarshallerContext().getJsonbContext(), event);
        return (T)deserializer.deserialize(ctx.getParser(), (DeserializationContext)ctx.getUnmarshallerContext(), contentType);
    }

    private void clearMapEntry() {
        this.key = null;
        this.value = null;
    }

    static class Context {
        private boolean parse;
        private final JsonParser parser;
        private final Unmarshaller unmarshallerContext;

        Context(JsonParser parser, Unmarshaller unmarshallerContext) {
            this.parser = parser;
            this.unmarshallerContext = unmarshallerContext;
            this.parse = true;
        }

        private boolean parse() {
            return this.parse;
        }

        public void finish() {
            this.parse = false;
        }

        public JsonParser getParser() {
            return this.parser;
        }

        public Unmarshaller getUnmarshallerContext() {
            return this.unmarshallerContext;
        }
    }

    private static enum State {
        NEXT_ENTRY,
        ENTRY_KEY,
        ENTRY_KEY_OBJECT,
        ENTRY_VALUE_OBJECT,
        ARRAY_END;

    }
}

