/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;

public class JsonNumberTypeDeserializer
extends AbstractValueTypeDeserializer<JsonNumber> {
    private static final String NUMBER = "number";

    public JsonNumberTypeDeserializer(Customization customization) {
        super(JsonNumber.class, customization);
    }

    @Override
    protected JsonNumber deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        JsonBuilderFactory factory = unmarshaller.getJsonbContext().getJsonProvider().createBuilderFactory(null);
        try {
            Integer integer = Integer.parseInt(jsonValue);
            JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, integer.intValue()).build();
            return jsonObject.getJsonNumber(NUMBER);
        }
        catch (NumberFormatException integer) {
            try {
                Long l = Long.parseLong(jsonValue);
                JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, l.longValue()).build();
                return jsonObject.getJsonNumber(NUMBER);
            }
            catch (NumberFormatException numberFormatException) {
                JsonObject jsonObject = factory.createObjectBuilder().add(NUMBER, new BigDecimal(jsonValue)).build();
                return jsonObject.getJsonNumber(NUMBER);
            }
        }
    }
}

