/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskEvent;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.UpdateCommandHandler;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\u0010!\u0001-B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"AA\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001W\u0011!Q\u0006A!A!\u0002\u00139\u0006\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011\u0001\u0004!\u0011!Q\u0001\nuC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005G\"1q\r\u0001C\u0001A!D\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fAq!!\b\u0001\t\u0013\ty\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u00111\f\u0001!\u0002\u0013\ti\u0003C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!+\u0001\t\u0003\nI\fC\u0004\u0002N\u0002!I!a4\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001e\u0001\u0005B\u0005=\bb\u0002B\u0019\u0001\u0011\u0005\u0013q\u000f\u0002\u0019\u000bZ,g\u000e^*pkJ\u001c\u0017N\\4UCN\\W*\u00198bO\u0016\u0014(BA\u0011#\u00035)g/\u001a8ug>,(oY5oO*\u00111\u0005J\u0001\u0005i\u0006\u001c8N\u0003\u0002&M\u0005)!.Y7fg*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00175qy\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004PE*,7\r\u001e\t\u0003kYj\u0011AI\u0005\u0003o\t\u00121\u0002V1tW6\u000bg.Y4feB\u0011\u0011\bP\u0007\u0002u)\u00111\bM\u0001\u0003S>L!!\u0010\u001e\u0003\u0013\rcwn]3bE2,\u0007CA E\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\n\u0011\u0002\\5gK\u000eL8\r\\3\n\u0005\u0015\u0003%!C*uCJ$\u0018M\u00197f\u0003E9xN]6Rk\u0016,XmU;qa2LWM\u001d\t\u0003\u0011&k\u0011\u0001I\u0005\u0003\u0015\u0002\u0012\u0011cV8sWF+X-^3TkB\u0004H.[3s\u0003))g/\u001a8u'R|'/Z\u000b\u0002\u001bB\u0011aJU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bKZ,g\u000e^:u_J,'BA\u0011%\u0013\t\u0019vJ\u0001\u0006Fm\u0016tGo\u0015;pe\u0016\f1\"\u001a<f]R\u001cFo\u001c:fA\u0005QR\r_3dkRLwN\u001c#fi\u0006LGn\u001d)s_*,7\r^5p]V\tq\u000b\u0005\u0002I1&\u0011\u0011\f\t\u0002\u001f)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\f1$\u001a=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:Qe>TWm\u0019;j_:\u0004\u0013\u0001\u00035pgRt\u0017-\\3\u0016\u0003u\u0003\"!\u000e0\n\u0005}\u0013#\u0001\u0003%pgRt\u0017-\\3\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0013!\u0006;fe6Lg.\u0019;j_:\u001cVOY:de&\u0014WM]\u000b\u0002GB\u0011\u0001\nZ\u0005\u0003K\u0002\u0012Q\u0003V3s[&t\u0017\r^5p]N+(m]2sS\n,'/\u0001\fuKJl\u0017N\\1uS>t7+\u001e2tGJL'-\u001a:!\u0003\u0019a\u0014N\\5u}Q1\u0011N[6m[:\u0004\"\u0001\u0013\u0001\t\u000b\u0019S\u0001\u0019A$\t\u000b-S\u0001\u0019A'\t\u000bUS\u0001\u0019A,\t\u000bmS\u0001\u0019A/\t\u000b\u0005T\u0001\u0019A2)\u0005)\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0019IgN[3di*\tQ/A\u0004kC.\f'\u000f^1\n\u0005]\u0014(AB%oU\u0016\u001cG\u000f\u000b\u0002\u000bsB\u0019!0a\u0002\u000e\u0003mT!\u0001`?\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003}~\faaY8n[>t'\u0002BA\u0001\u0003\u0007\taaZ8pO2,'BAA\u0003\u0003\r\u0019w.\\\u0005\u0004\u0003\u0013Y(!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u00061AjT$H\u000bJ+\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006)\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\tI\"a\u0005\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\nab^8sW\u0012K7\u000f]1uG\",'/\u0006\u0002\u0002\"A!\u00111EA\u0013\u001b\u0005\t\u0016bAA\u0014#\nQ1+\u001e2tGJL'-\u001a:\u0002\u00171|\u0017\r\u001a%jgR|'/_\u000b\u0003\u0003[\u0001\u0002\"a\f\u00026\u0005e\u0012qH\u0007\u0003\u0003cQ!!a\r\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005]\u0012\u0011\u0007\u0002\n\rVt7\r^5p]F\u0002B!a\t\u0002<%\u0019\u0011QH)\u0003\u0017\u0005;wM]3hCR,\u0017\n\u001a\t\u0007\u0003\u0003\n\t&!\u0016\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\t\u0005M\u0012\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0003d_J,'BAA(\u0003\u001d\u0011X-Y2u_JLA!a\u0015\u0002D\t)1+T8o_B\u0019a*a\u0016\n\u0007\u0005esJA\u0004ISN$xN]=\u0002\u00191|\u0017\r\u001a%jgR|'/\u001f\u0011\u0002'\u00154XM\u001c;T_V\u00148-\u001b8h'f\u001cH/Z7\u0016\u0005\u0005\u0005\u0004\u0003BA\u0012\u0003GJ1!!\u001aR\u0005M)e/\u001a8u'>,(oY5oONK8\u000f^3n\u0003Q)g/\u001a8u'>,(oY5oONK8\u000f^3nA\u0005Iqo\u001c:l#V,W/Z\u000b\u0003\u0003[\u00022!NA8\u0013\r\t\tH\t\u0002\n/>\u00148.U;fk\u0016\f!b^8sWF+X-^3!\u0003\u0015\u0019H/\u0019:u)\t\tI\b\u0005\u0003\u00020\u0005m\u0014\u0002BA?\u0003c\u0011A!\u00168ji\u00069!/Z:uCJ$\u0018AB:vE6LG\u000f\u0006\u0003\u0002\u0006\u0006-\u0005cA\u001b\u0002\b&\u0019\u0011\u0011\u0012\u0012\u0003\rQ\u000b7o[%e\u0011\u0019\u0019c\u00031\u0001\u0002\u000eB\u0019Q'a$\n\u0007\u0005E%E\u0001\u0003UCN\\\u0017aE4fi\u0016CXmY;uS>tG)\u001a;bS2\u001cH\u0003BAL\u0003;\u00032!NAM\u0013\r\tYJ\t\u0002\u0015)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:\t\u000f\u0005}u\u00031\u0001\u0002\u0006\u0006\u0011\u0011\u000eZ\u0001\u001cO\u0016$X\t_3dkRLwN\u001c#fi\u0006LGn\u001d*fC\u000e$\u0018N^3\u0015\t\u0005\u0015\u0016q\u0015\t\u0007\u0003\u0003\n\t&a&\t\u000f\u0005}\u0005\u00041\u0001\u0002\u0006\u0006!A.[:u)\t\ti\u000b\u0005\u0004\u00020\u0006U\u0016qS\u0007\u0003\u0003cS1!a-1\u0003\u0011)H/\u001b7\n\t\u0005]\u0016\u0011\u0017\u0002\u0005\u0019&\u001cH\u000f\u0006\u0003\u0002.\u0006m\u0006bBA_5\u0001\u0007\u0011qX\u0001\u0007gR\fG/^:\u0011\t\u0005\u0005\u0017q\u0019\b\u0004k\u0005\r\u0017bAAcE\u0005YA+Y:l\u001b\u0006t\u0017mZ3s\u0013\u0011\tI-a3\u0003\rM#\u0018\r^;t\u0015\r\t)MI\u0001\nY&\u001cHoU2bY\u0006,\"!!5\u0011\r\u0005M\u00171]AL\u001d\u0011\t).a8\u000f\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7+\u0003\u0019a$o\\8u}%\u0011\u00111G\u0005\u0005\u0003C\f\t$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0016Q\u001d\u0006\u0005\u0003C\f\t$\u0001\u0004dC:\u001cW\r\u001c\u000b\u0005\u0003s\nY\u000fC\u0004\u0002 r\u0001\r!!\"\u0002\u000b\u0005<\u0018-\u001b;\u0015\r\u0005]\u0015\u0011_Az\u0011\u001d\ty*\ba\u0001\u0003\u000bCq!!>\u001e\u0001\u0004\t90A\u0004uS6,w.\u001e;\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@1\u0003\u0011!\u0018.\\3\n\t\t\u0005\u00111 \u0002\t\tV\u0014\u0018\r^5p]\"*QD!\u0002\u0003\u0012A1\u0011q\u0006B\u0004\u0005\u0017IAA!\u0003\u00022\t1A\u000f\u001b:poN\u00042!\u000eB\u0007\u0013\r\u0011yA\t\u0002\u0016)\u0006\u001c8NT8u\r>,h\u000eZ#yG\u0016\u0004H/[8oG\t\u0011Y\u0001K\u0003\u001e\u0005+\u0011y\u0003\u0005\u0004\u00020\t\u001d!q\u0003\t\u0005\u00053\u0011YC\u0004\u0003\u0003\u001c\u0005\rg\u0002\u0002B\u000f\u0005SqAAa\b\u0003(9!!\u0011\u0005B\u0013\u001d\u0011\t9Na\t\n\u0003%J!a\n\u0015\n\u0005\u00152\u0013BA\u0012%\u0013\u0011\u0011i#a3\u0003/I+\u0017m\u00195fIRKW.Z8vi\u0016C8-\u001a9uS>t7E\u0001B\f\u0003\u0015\u0019Gn\\:fQ\rq\"Q\u0007\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)\u0019!1\b;\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003@\te\"A\u0003)sK\u0012+7\u000f\u001e:ps\u0002")
public class EventSourcingTaskManager
implements TaskManager,
Closeable,
Startable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final Logger LOGGER;
    private final Function1<AggregateId, SMono<History>> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    public Logger LOGGER() {
        return this.LOGGER;
    }

    private Subscriber workDispatcher() {
        return event -> {
            Event event2 = event.event();
            if (event2 instanceof Created) {
                Created created = (Created)event2;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                return;
            }
            if (event2 instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event2;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                return;
            }
        };
    }

    private Function1<AggregateId, SMono<History>> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    public void start() {
        this.workQueue().start();
    }

    public void restart() {
        this.workQueue().restart();
    }

    public TaskId submit(Task task) {
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
        return taskId;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    private SMono<TaskExecutionDetails> getExecutionDetailsReactive(TaskId id) {
        return SMono$.MODULE$.apply(this.executionDetailsProjection().loadReactive(id)).switchIfEmpty(SMono$.MODULE$.error((Throwable)new TaskNotFoundException()));
    }

    public java.util.List<TaskExecutionDetails> list() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.listScala()).asJava();
    }

    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.listScala().filter((Function1 & Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return this.executionDetailsProjection().list();
    }

    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public TaskExecutionDetails await(TaskId id, java.time.Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        TaskExecutionDetails taskExecutionDetails;
        try {
            Mono details = Mono.from(this.getExecutionDetailsReactive(id)).filter(x$1 -> x$1.getStatus().isFinished());
            Mono findEvent = Flux.from(this.terminationSubscriber().listenEvents()).filter(x0$1 -> {
                Event event = x0$1;
                if (event instanceof TaskEvent) {
                    TaskEvent taskEvent = (TaskEvent)event;
                    TaskId taskId = taskEvent.getAggregateId().taskId();
                    TaskId taskId2 = id;
                    return !(taskId != null ? !taskId.equals(taskId2) : taskId2 != null);
                }
                return false;
            }).next().then(details);
            taskExecutionDetails = (TaskExecutionDetails)Flux.merge((Publisher[])new Publisher[]{findEvent, details}).blockFirst(timeout);
        }
        catch (IllegalStateException illegalStateException) {
            throw new TaskManager.ReachedTimeoutException();
        }
        return taskExecutionDetails;
    }

    @Override
    @PreDestroy
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.LOGGER = LoggerFactory.getLogger(EventSourcingTaskManager.class);
        this.loadHistory = (Function1 & Serializable)aggregateId -> SMono$.MODULE$.apply(this.eventStore().getEventsOfAggregate(aggregateId));
        this.eventSourcingSystem = new EventSourcingSystem((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory()), new UpdateCommandHandler(this.loadHistory())})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber})), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

