/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.api;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DelegationUserDeletionTaskStep
implements DeleteUserDataTaskStep {
    private final DelegationStore delegationStore;

    @Inject
    public DelegationUserDeletionTaskStep(DelegationStore delegationStore) {
        this.delegationStore = delegationStore;
    }

    @Override
    public DeleteUserDataTaskStep.StepName name() {
        return new DeleteUserDataTaskStep.StepName("DelegationUserDeletionTaskStep");
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public Publisher<Void> deleteUserData(Username username) {
        return this.removeDelegatedUsers(username).then(this.removeDelegatingUsers(username));
    }

    private Mono<Void> removeDelegatedUsers(Username username) {
        return Flux.from(this.delegationStore.delegatedUsers(username)).concatMap(delegator -> this.delegationStore.removeAuthorizedUser((Username)delegator, username)).then();
    }

    private Mono<Void> removeDelegatingUsers(Username username) {
        return Flux.from(this.delegationStore.authorizedUsers(username)).concatMap(delegatee -> this.delegationStore.removeAuthorizedUser(username, (Username)delegatee)).then();
    }
}

