/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lib.jmx.AbstractCommandHandlerStats;

public abstract class AbstractCommandHandlerResultJMXMonitor<S extends ProtocolSession>
implements ProtocolHandlerResultHandler<Response, S>,
ExtensibleHandler,
ProtocolHandler {
    private final Map<String, AbstractCommandHandlerStats> cStats = new HashMap<String, AbstractCommandHandlerStats>();
    private String jmxName;

    public Response onResponse(ProtocolSession session, Response response, long executionTime, ProtocolHandler handler) {
        String name;
        AbstractCommandHandlerStats stats;
        if (handler instanceof CommandHandler && (stats = this.cStats.get(name = handler.getClass().getName())) != null) {
            stats.increment(response);
        }
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(CommandHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(CommandHandler.class)) {
            for (Object anExtension : extension) {
                CommandHandler c = (CommandHandler)anExtension;
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.cStats.put(cName, this.createCommandHandlerStats(c));
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected abstract AbstractCommandHandlerStats createCommandHandlerStats(CommandHandler<S> var1) throws Exception;

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    protected abstract String getDefaultJMXName();

    protected String getJMXName() {
        return this.jmxName;
    }

    public void destroy() {
        for (AbstractCommandHandlerStats abstractCommandHandlerStats : this.cStats.values()) {
            abstractCommandHandlerStats.dispose();
        }
    }
}

