/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.MessagingException;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.mailet.base.GenericRecipientMatcher;

public class UserIs
extends GenericRecipientMatcher {
    Set<String> users;

    public void init() throws MessagingException {
        if (Strings.isNullOrEmpty((String)this.getCondition())) {
            throw new MessagingException("UserIs should have a condition composed of a list of local parts of mail addresses");
        }
        this.users = ImmutableSet.copyOf((Iterable)Splitter.on((String)", ").split((CharSequence)this.getCondition()));
        if (this.users.isEmpty()) {
            throw new MessagingException("UserIs should have at least a user specified");
        }
    }

    public boolean matchRecipient(MailAddress recipient) {
        return this.users.contains(recipient.getLocalPart());
    }
}

