/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.wiring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.james.jspf.wiring.WiringService;
import org.apache.james.jspf.wiring.WiringServiceException;

public class WiringServiceTable
extends Hashtable<Class<?>, Object>
implements WiringService {
    private static final long serialVersionUID = -9151935136150279119L;

    @Override
    public void wire(Object component) throws WiringServiceException {
        for (Class enablingClass : this.keySet()) {
            Method[] m;
            if (!enablingClass.isInstance(component) || (m = enablingClass.getDeclaredMethods()) == null || m.length != 1 || m[0] == null) continue;
            try {
                m[0].invoke(component, this.get(enablingClass));
            }
            catch (IllegalArgumentException e) {
                throw new WiringServiceException("Illegal argument invoking enabled service: " + enablingClass.toString(), e);
            }
            catch (InvocationTargetException e) {
                throw new WiringServiceException("Unable to invoke enabled service: " + enablingClass.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new WiringServiceException("Unable to invoke enabled service: " + enablingClass.toString(), e);
            }
        }
    }
}

