/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import java.util.Collection;
import javax.management.MalformedObjectNameException;
import org.apache.james.adapter.mailbox.MailboxCopierManagementMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.adapter.mailbox.ReIndexerManagementMBean;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.mailbox.model.MailboxId;

public class JmxMailboxProbe
implements JmxProbe {
    private static final String MAILBOXCOPIER_OBJECT_NAME = "org.apache.james:type=component,name=mailboxcopier";
    private static final String MAILBOXMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=mailboxmanagerbean";
    private static final String REINDEXER_OBJECT_NAME = "org.apache.james:type=component,name=reindexerbean";
    private MailboxCopierManagementMBean mailboxCopierManagement;
    private MailboxManagerManagementMBean mailboxManagerManagement;
    private ReIndexerManagementMBean reIndexerManagement;

    @Override
    public JmxMailboxProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.mailboxCopierManagement = jmxc.retrieveBean(MailboxCopierManagementMBean.class, MAILBOXCOPIER_OBJECT_NAME);
            this.mailboxManagerManagement = jmxc.retrieveBean(MailboxManagerManagementMBean.class, MAILBOXMANAGER_OBJECT_NAME);
            this.reIndexerManagement = jmxc.retrieveBean(ReIndexerManagementMBean.class, REINDEXER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void copyMailbox(String srcBean, String dstBean) throws Exception {
        this.mailboxCopierManagement.copy(srcBean, dstBean);
    }

    public void deleteUserMailboxesNames(String user) throws Exception {
        this.mailboxManagerManagement.deleteMailboxes(user);
    }

    public MailboxId createMailbox(String namespace, String user, String name) {
        return this.mailboxManagerManagement.createMailbox(namespace, user, name);
    }

    public Collection<String> listUserMailboxes(String user) {
        return this.mailboxManagerManagement.listMailboxes(user);
    }

    public void deleteMailbox(String namespace, String user, String name) {
        this.mailboxManagerManagement.deleteMailbox(namespace, user, name);
    }

    public void importEmlFileToMailbox(String namespace, String user, String name, String emlpath) {
        this.mailboxManagerManagement.importEmlFileToMailbox(namespace, user, name, emlpath);
    }

    public void reIndexMailbox(String namespace, String user, String name) throws Exception {
        this.reIndexerManagement.reIndex(namespace, user, name);
    }

    public void reIndexAll() throws Exception {
        this.reIndexerManagement.reIndex();
    }
}

