/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import jakarta.inject.Inject;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.protocols.api.handler.ProtocolHandler;

public class DNSRBLHandler
extends org.apache.james.protocols.smtp.core.fastfail.DNSRBLHandler
implements ProtocolHandler {
    private final DNSService dns;

    @Inject
    public DNSRBLHandler(DNSService dns) {
        this.dns = dns;
    }

    public void init(Configuration config) throws ConfigurationException {
        boolean validConfig = false;
        HierarchicalConfiguration handlerConfiguration = (HierarchicalConfiguration)config;
        ArrayList rblserverCollection = new ArrayList();
        Collections.addAll(rblserverCollection, handlerConfiguration.getStringArray("rblservers.whitelist"));
        if (rblserverCollection.size() > 0) {
            this.setWhitelist((String[])rblserverCollection.toArray(String[]::new));
            rblserverCollection.clear();
            validConfig = true;
        }
        Collections.addAll(rblserverCollection, handlerConfiguration.getStringArray("rblservers.blacklist"));
        if (rblserverCollection.size() > 0) {
            this.setBlacklist((String[])rblserverCollection.toArray(String[]::new));
            rblserverCollection.clear();
            validConfig = true;
        }
        if (!validConfig) {
            throw new ConfigurationException("Please configure whitelist or blacklist");
        }
        this.setGetDetail(handlerConfiguration.getBoolean("getDetail", false));
    }

    protected boolean resolve(String ip) {
        try {
            this.dns.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    protected Collection<String> resolveTXTRecords(String ip) {
        return this.dns.findTXTRecords(ip);
    }
}

