/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.dsn;

import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.dsn.DSNMailParameterHook;
import org.apache.james.smtpserver.dsn.DSNRcptParameterHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;

public class DSNMessageHook
implements JamesMessageHook {
    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        Optional ret = session.getAttachment(DSNMailParameterHook.DSN_RET, ProtocolSession.State.Transaction);
        Optional envId = session.getAttachment(DSNMailParameterHook.DSN_ENVID, ProtocolSession.State.Transaction);
        ImmutableMap rcptParameters = session.getAttachment(DSNRcptParameterHook.DSN_RCPT_PARAMETERS, ProtocolSession.State.Transaction).map(DSNRcptParameterHook.Builder::build).orElse(ImmutableMap.of());
        DsnParameters.of((Optional)envId, (Optional)ret, (ImmutableMap)rcptParameters).ifPresent(arg_0 -> ((Mail)mail).setDsnParameters(arg_0));
        mail.setAttribute(new Attribute(AttributeName.of((String)"dsn-arrival-date"), AttributeValue.of((ZonedDateTime)ZonedDateTime.now())));
        return HookResult.DECLINED;
    }
}

