/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.data.jmap.PopulateEmailQueryViewTask;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.apache.james.webadmin.data.jmap.RunningOptionsDTO;

public class PopulateEmailQueryViewTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final Instant timestamp;
    private final long processedUserCount;
    private final long processedMessageCount;
    private final long failedUserCount;
    private final long failedMessageCount;
    private final Optional<RunningOptionsDTO> runningOptions;

    public static AdditionalInformationDTOModule<PopulateEmailQueryViewTask.AdditionalInformation, PopulateEmailQueryViewTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(PopulateEmailQueryViewTask.AdditionalInformation.class).convertToDTO(PopulateEmailQueryViewTaskAdditionalInformationDTO.class).toDomainObjectConverter(PopulateEmailQueryViewTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(PopulateEmailQueryViewTaskAdditionalInformationDTO::toDTO).typeName(PopulateEmailQueryViewTask.TASK_TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private static PopulateEmailQueryViewTask.AdditionalInformation toDomainObject(PopulateEmailQueryViewTaskAdditionalInformationDTO dto) {
        return new PopulateEmailQueryViewTask.AdditionalInformation(dto.getRunningOptions().map(RunningOptionsDTO::asDomainObject).orElse(RunningOptions.DEFAULT), dto.getProcessedUserCount(), dto.getProcessedMessageCount(), dto.getFailedUserCount(), dto.getFailedMessageCount(), dto.timestamp);
    }

    private static PopulateEmailQueryViewTaskAdditionalInformationDTO toDTO(PopulateEmailQueryViewTask.AdditionalInformation details, String type) {
        return new PopulateEmailQueryViewTaskAdditionalInformationDTO(type, details.timestamp(), details.getProcessedUserCount(), details.getProcessedMessageCount(), details.getFailedUserCount(), details.getFailedMessageCount(), Optional.of(RunningOptionsDTO.asDTO(details.getRunningOptions())));
    }

    @VisibleForTesting
    PopulateEmailQueryViewTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="processedUserCount") long processedUserCount, @JsonProperty(value="processedMessageCount") long processedMessageCount, @JsonProperty(value="failedUserCount") long failedUserCount, @JsonProperty(value="failedMessageCount") long failedMessageCount, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.timestamp = timestamp;
        this.processedUserCount = processedUserCount;
        this.processedMessageCount = processedMessageCount;
        this.failedUserCount = failedUserCount;
        this.failedMessageCount = failedMessageCount;
        this.runningOptions = runningOptions;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getProcessedUserCount() {
        return this.processedUserCount;
    }

    public long getProcessedMessageCount() {
        return this.processedMessageCount;
    }

    public long getFailedUserCount() {
        return this.failedUserCount;
    }

    public long getFailedMessageCount() {
        return this.failedMessageCount;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }
}

