/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.TokenizedJwt;
import io.jsonwebtoken.lang.Strings;
import java.util.Map;

class DefaultTokenizedJwt
implements TokenizedJwt {
    private final CharSequence protectedHeader;
    private final CharSequence payload;
    private final CharSequence digest;

    DefaultTokenizedJwt(CharSequence protectedHeader, CharSequence payload, CharSequence digest) {
        this.protectedHeader = protectedHeader;
        this.payload = payload;
        this.digest = digest;
    }

    @Override
    public CharSequence getProtected() {
        return this.protectedHeader;
    }

    @Override
    public CharSequence getPayload() {
        return this.payload;
    }

    @Override
    public CharSequence getDigest() {
        return this.digest;
    }

    @Override
    public Header createHeader(Map<String, ?> m) {
        if (Strings.hasText((CharSequence)this.getDigest())) {
            return new DefaultJwsHeader(m);
        }
        return new DefaultHeader(m);
    }
}

