/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty.websocket;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;

public class WebSocketHandlerClassWrapper
implements WebSocketHandlerWrapper {
    private final Class<?> handlerClass;

    public WebSocketHandlerClassWrapper(Class<?> handlerClass) {
        Objects.requireNonNull(handlerClass, "WebSocket handler class cannot be null");
        WebSocketHandlerWrapper.validateHandlerClass(handlerClass);
        this.handlerClass = handlerClass;
    }

    @Override
    public Object getHandler() {
        try {
            return this.handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Could not instantiate websocket handler", ex);
        }
    }
}

